import 'dart:convert';
import 'dart:io';
import 'package:dio/adapter.dart';
import 'package:dio/dio.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';

import 'Api.dart';
import 'DioCookieManager.dart';
import 'DioInterceptor.dart';

const NET_COOKIE = "NET_COOKIE";

class DioUtil {
  static BaseOptions _options = BaseOptions();
  static final DioUtil _instance = DioUtil._init();
  static Dio _dio;

  static Map<String, dynamic> addHeadMap;

  /// 是否是debug模式.
  static bool _isDebug = isDebug;

  static DioUtil getInstance() {
    return _instance;
  }

  factory DioUtil() {
    return _instance;
  }

  static var interceptor = InterceptorsWrapper();

  DioUtil._init() {
    setDefOptions();
    _dio = new Dio(_options);
    _dio.interceptors.add(DioInterceptorManager.getInstance().getIntercept());
//    _dio.interceptors.add(DioCookieManager.getInstance().getCookieManager());
  }

  void changeOpt() {
    _dio = new Dio(_options);
    _dio.interceptors.add(DioInterceptorManager.getInstance().getIntercept());
  }

  void clearCookie() {
    DioCookieManager.getInstance().clearCookie();
  }

  void setProxy(String proxy, {String port}) {
    _dio = new Dio(_options);
    _dio.interceptors.add(DioInterceptorManager.getInstance().getIntercept());
    _dio.interceptors.add(DioCookieManager.getInstance().getCookieManager());
    (_dio.httpClientAdapter as DefaultHttpClientAdapter).onHttpClientCreate =
        (client) {
      client.findProxy = (url) {
        return 'PROXY $proxy:${port ?? 8888}';
      };
    };
  }

  Dio getDio() {
    return _dio;
  }

  static void setDefOptions({String baseUrl, String agent}) {
    _options.connectTimeout = 10 * 1000;
    _options.receiveTimeout = 20 * 1000;
    _options.responseType = ResponseType.plain;
    Map<String, dynamic> headers = Map<String, dynamic>();
    headers['Accept'] = 'application/json';
    if (agent != null) {
      headers['User-Agent'] = agent;
    }
    _options.headers = headers;
    print("ISEMPTY ?? ${baseUrl}  ${Api.getInstance().getBaseUrl()}");
    _options.baseUrl = baseUrl ?? "${Api.getInstance().getBaseUrl()}/";
  }
}
