/*
 * @author lsy
 * @date   2020/7/1
 **/
class PlanFeedBean {
  int error;
  String message;
  Map extra;
  int errorCode;
  Map errorExtra;
  Data data;
  UserType userType;

  String tag_id;
  String order_by;
  String min_price;
  String max_price;
  int page;

  PlanFeedBean(
      {this.error,
      this.message,
      this.extra,
      this.errorCode,
      this.errorExtra,
      this.data,
      this.userType});

  PlanFeedBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];

    tag_id = json['tag_id'];
    order_by = json['order_by'];
    min_price = json['min_price'];
    max_price = json['max_price'];
    page = json['page'];

    errorCode = json['error_code'];
    errorExtra = json['error_extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;

    data['tag_id'] = this.tag_id;
    data['order_by'] = this.order_by;
    data['min_price'] = this.min_price;
    data['max_price'] = this.max_price;
    data['page'] = this.page;

    data['error_code'] = this.errorCode;
    data['error_extra'] = this.errorExtra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    return data;
  }
}

class Data {
  List<Plans> plans;

  Data({this.plans});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['plans'] != null) {
      plans = new List<Plans>();
      json['plans'].forEach((v) {
        plans.add(new Plans.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.plans != null) {
      data['plans'] = this.plans.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Plans {
  int id;
  String cardType;
  String name;
  String positiveRate;
  String salesCount;
  List<String> baseAttrs;
  String minPrice;
  String maxPrice;
  String projectImage;
  String operation_type;

  Plans(
      {this.id,
      this.cardType,
      this.name,
      this.positiveRate,
      this.salesCount,
      this.baseAttrs,
      this.minPrice,
      this.maxPrice,
      this.projectImage});

  Plans.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    cardType = json['card_type'];
    name = json['name'];
    positiveRate = json['positive_rate'];
    operation_type = json['operation_type'];
    salesCount = json['sales_count'];
    baseAttrs = json['base_attrs'].cast<String>();
    minPrice =
        json['min_price'] is int ? "${json['min_price']}" : json['min_price'];
    maxPrice =
        json['max_price'] is int ? "${json['max_price']}" : json['max_price'];
    projectImage = json['project_image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['card_type'] = this.cardType;
    data['operation_type'] = this.operation_type;
    data['name'] = this.name;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    data['base_attrs'] = this.baseAttrs;
    data['min_price'] = this.minPrice;
    data['max_price'] = this.maxPrice;
    data['project_image'] = this.projectImage;
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}
