/*
 * @author lsy
 * @date   2020/5/14
 **/
class KYCBean {
  int error;
  String message;
  Data data;

  KYCBean({this.error, this.message, this.data});

  KYCBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  bool needScan;
  List<Questions> questions;

  Data({this.needScan, this.questions});

  Data.fromJson(Map<String, dynamic> json) {
    needScan = json['need_scan'];
    if (json['questions'] != null) {
      questions = new List<Questions>();
      json['questions'].forEach((v) {
        questions.add(new Questions.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['need_scan'] = this.needScan;
    if (this.questions != null) {
      data['questions'] = this.questions.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Questions {
  String identifier;
  String question;
  List<Choices> choices;

  Questions({this.identifier, this.question, this.choices});

  Questions.fromJson(Map<String, dynamic> json) {
    identifier = json['identifier'];
    question = json['question'];
    if (json['choices'] != null) {
      choices = new List<Choices>();
      json['choices'].forEach((v) {
        choices.add(new Choices.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['identifier'] = this.identifier;
    data['question'] = this.question;
    if (this.choices != null) {
      data['choices'] = this.choices.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Choices {
  int id;
  String image;
  String text;

  Choices({this.id, this.image, this.text});

  Choices.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    image = json['image'];
    text = json['text'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['image'] = this.image;
    data['text'] = this.text;
    return data;
  }
}

