/*
 * @author lsy
 * @date   2020/7/5
 **/
import 'package:dio/dio.dart';

class SimpleEventBus{
  static SimpleEventBus _eventBus;
  SimpleEventBus._();
  static SimpleEventBus instance(){
    if(_eventBus==null){
      _eventBus=SimpleEventBus._();
    }
    return _eventBus;
  }

  Map<String,List<Function(String str)>> map=Map();

  void resignEvent(String name,Function(String str) func){
    if(map[name]==null){
      map[name]=[];
    }
    map[name].add(func);
  }

  void unResignEvent(String name,Function(String str) func){
    if(map[name]==null){
      return;
    }
    map[name].remove(func);
  }

  void notifyListener(String name,String str){
    if(map[name]==null){
      return;
    }
    map[name].forEach((element) {
      element(str);
    });
  }

}