import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';

class PlansCompareFeedItemView extends StatelessWidget {
  Plans plan;

  PlansCompareFeedItemView(this.plan);

  @override
  Widget build(BuildContext context) {
    return Container(child: getItem());
  }

  getItem() {
    if (plan.planType == 1) {
      return getFirstLevelItem();
    } else {
      return getSecondLevelItem();
    }
  }

  getFirstLevelItem() {
    return Container(
      width: double.maxFinite,
      height: 90,
      alignment: Alignment.centerLeft,
      padding: EdgeInsets.only(left: 15, right: 15, top: 20, bottom: 20),
      child: Row(
        children: <Widget>[
          IconButton(
            icon: ImageIcon(AssetImage("assets/icon_compare_select.png")),
            onPressed: () => print('FlatButton pressed'),
          ),
          Container(
            margin: EdgeInsets.only(left: 15, right: 15),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(2.0),
              child: Image.network(
                plan.projectImage,
                width: 50,
                height: 50,
                fit: BoxFit.fill,
              ),
            ),
          ),
          Container(
            height: 50,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  margin: EdgeInsets.only(top: 2, bottom: 5),
                  child: Row(
                    children: <Widget>[
                      Text(
                        plan.name,
                        style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: 14,
                            color: Color(0xFF282828)),
                        maxLines: 1,
                      ),
                      Text(
                        "好评率 ",
                        style:
                            TextStyle(fontSize: 11, color: Color(0xFF282828)),
                        maxLines: 1,
                      ),
                      Text(
                        plan.positiveRate,
                        style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: 14,
                            color: Color(0xFFFF5963)),
                        maxLines: 1,
                      ),
                    ],
                  ),
                ),
                Row(
                  children: <Widget>[
                    Text(
                      '￥${plan.minPrice}-${plan.maxPrice}',
                      style: TextStyle(fontSize: 13, color: Color(0xFFFF5963)),
                    ),
                    Text(
                      "销量${plan.salesCount}",
                      style: TextStyle(fontSize: 11, color: Color(0xFF282828)),
                      maxLines: 1,
                    )
                  ],
                )
              ],
            ),
          )
        ],
      ),
    );
  }

  getSecondLevelItem() {
    return Container(
      width: double.maxFinite,
      height: 77,
      alignment: Alignment.centerLeft,
      margin: EdgeInsets.only(left: 15, right: 15),
      child: Row(
        children: <Widget>[
          Container(
            alignment: Alignment.centerLeft,
            width: 17,
            height: 17,
            child: IconButton(
              icon: ImageIcon(AssetImage("assets/icon_compare_select.png")),
              onPressed: () => print('FlatButton pressed'),
            ),
          ),
          Container(
            margin: EdgeInsets.only(left: 15.0),
            height: 77,
            alignment: Alignment.centerLeft,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  margin: EdgeInsets.only(top: 13.0, bottom: 12),
                  child: Text(
                    plan.name,
                    style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: 14,
                        color: Color(0xFF282828)),
                    maxLines: 1,
                  ),
                ),
                Row(
                  children: <Widget>[
                    Text(
                      '￥${plan.minPrice}-${plan.maxPrice}',
                      style: TextStyle(fontSize: 13, color: Color(0xFFFF5963)),
                    ),
                    Container(
                      alignment: Alignment.centerRight,
                      child: Text(
                        "指导价：￥${plan.guidePrice}",
                        style:
                            TextStyle(fontSize: 11, color: Color(0xFF282828)),
                        maxLines: 1,
                      ),
                    ),
                  ],
                )
              ],
            ),
          )
        ],
      ),
    );
  }

}
