/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/main.mark.dart';

class LevelOneItem extends StatelessWidget {
  final Cards cards;
  VoidCallback lowPrice;
  VoidCallback ask;
  Function(int planId) compare;
  Function(int planId) gotoPlan;
  int position;
  String tabName;
  LevelOneItem(this.cards,
      {this.lowPrice,
      this.ask,
      this.compare,
      this.gotoPlan,
      this.position,
      this.tabName});

  @override
  Widget build(BuildContext context) {
    if (cards.cardType == "plan") {
      return PlanItem(context);
    } else if (cards.cardType == "hospital") {
      return HospitalItem(context);
    } else if (cards.cardType == "doctor") {
      return DoctorItem(context);
    } else if (cards.cardType == "diary") {
      return DiaryItem(context);
    }
  }

  static double getCardTypeHeight(Cards cards) {
    if (cards.cardType == "plan") {
      return 118;
    } else if (cards.cardType == "hospital") {
      return 149;
    } else if (cards.cardType == "doctor") {
      return 127;
    } else if (cards.cardType == "diary") {
      double image = (cards.diary.images == null ||
              cards.diary.images.isEmpty ||
              cards.diary.images.length < 2)
          ? 0
          : 175;
      double text = 22 * (cards.diary.content.length / 22) + 24.5;
      return 40 + image + text + 55;
    }
    return 0;
  }

  Widget DoctorItem(BuildContext context) {
    if (cards.doctor == null && isDebug) {
      throw new Exception();
    }
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      onTap: () {
        Map<String, dynamic> buriedMap;
        buriedMap = {
          "tab_name": tabName,
          "position": position,
          "card_id": cards.doctor.doctor_id,
          "card_name": "card",
          "card_type": "card",
          "transaction_type": "",
          "card_content_type": "doctor"
        };
        RouterCenterImpl()
            .findMainRouter()
            .buriedEvent("on_click_card", buriedMap);

        Map<String, dynamic> map = {
          "business_id": "${cards.doctor.doctor_id}",
        };
        RouterCenterImpl()
            .findMainRouter()
            .jumpPage(context, cards.doctor.messageUrl, map, true);
      },
      child: Container(
        margin: EdgeInsets.only(left: 15, right: 15),
        height: 127,
        child: Stack(
          children: <Widget>[
            Positioned(
              top: 15,
              child: Container(
                width: 45,
                height: 45,
                child: ClipOval(
                  child: CachedNetworkImage(
                    imageUrl: cards.doctor.portrait,
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            Positioned(
              left: 57,
              top: 48,
              child: FiveStarView(int.parse(cards.doctor.star), 5),
            ),
            Positioned(
              left: 57,
              top: 18,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  baseText(cards.doctor.name, 15, Color(0xff333333),
                      bold: true),
                  Container(
                    margin: EdgeInsets.only(left: 4),
                    child: baseText(cards.doctor.title, 13, Color(0xff999999),
                        bold: true),
                  )
                ],
              ),
            ),
            Positioned(
              top: 42,
              right: 0,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.end,
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  baseText("¥", 12, Color(0xffFF5963)),
                  baseText("${cards.doctor.minPrice}-${cards.doctor.maxPrice}",
                      15, Color(0xffFF5963)),
                ],
              ),
            ),
            Positioned(
              left: 57,
              bottom: 15,
              child: Container(
                width: MediaQuery.of(context).size.width - 30 - 57,
                child: Row(
                  children: <Widget>[
                    Expanded(
                      child: askWidget(),
                    ),
                    Container(
                      width: 15,
                    ),
                    Expanded(
                      child: lowPriceWidget(),
                    )
                  ],
                ),
              ),
            ),
//            Positioned(
//              bottom: 15,
//              right: 0,
//              child: lowPriceWidget(),
//            ),
//            Positioned(
//              bottom: 15,
//              right: 137,
//              child: askWidget(),
//            ),
//            Positioned(
//              left: 4.5,
//              bottom: 25,
//              child: compareWidget(),
//            ),
            Positioned(
              left: 0,
              bottom: 0,
              child: Container(
                width: MediaQuery.of(context).size.width - 30,
                height: 0.5,
                color: Color(0xffE5E5E5),
              ),
            )
          ],
        ),
      ),
    );
  }

  Widget HospitalItem(BuildContext context) {
    if (cards.hospital == null && isDebug) {
      throw new Exception();
    }
    return GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: () {
          Map<String, dynamic> buriedMap;
          buriedMap = {
            "tab_name": tabName,
            "position": position,
            "card_id": cards.hospital.hosiptalId,
            "card_name": "card",
            "card_type": "card",
            "transaction_type": "",
            "card_content_type": "hospital"
          };
          RouterCenterImpl()
              .findMainRouter()
              .buriedEvent("on_click_card", buriedMap);
          Map<String, dynamic> map = {
            "business_id": "${cards.hospital.hosiptalId}",
          };
          RouterCenterImpl()
              .findMainRouter()
              .jumpPage(context, cards.hospital.messageUrl, map, true);
        },
        child: Container(
          margin: EdgeInsets.only(left: 15, right: 15),
          height: 149,
          child: Stack(
            children: <Widget>[
              Positioned(
                left: 0,
                top: 15,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.hospital.portrait,
                    ),
                  ),
                ),
              ),
              Positioned(
                left: 57,
                top: 17.5,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30 - 57,
                  child: baseText(cards.hospital.name, 15, Color(0xff333333),
                      bold: true),
                ),
              ),
              Positioned(
                top: 42.5,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText(
                        "${cards.hospital.minPrice}-${cards.hospital.maxPrice}",
                        15,
                        Color(0xffFF5963),
                        bold: true),
                  ],
                ),
              ),
              Positioned(
                bottom: 15,
                left: 57,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30 - 57,
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: askWidget(),
                      ),
                      Container(
                        width: 15,
                      ),
                      Expanded(
                        child: lowPriceWidget(),
                      )
                    ],
                  ),
                ),
              ),
//              Positioned(
//                bottom: 15,
//                right: 0,
//                child: lowPriceWidget(),
//              ),
//              Positioned(
//                bottom: 15,
//                right: 137,
//                child: askWidget(),
//              ),
//              Positioned(
//                left: 4.5,
//                bottom: 25,
//                child: compareWidget(),
//              ),
              Positioned(
                bottom: 63.5,
                left: 57,
                child: baseText(cards.hospital.address, 12, Color(0xff666666)),
              ),
              Positioned(
                left: 57,
                top: 47,
                child: FiveStarView(int.parse(cards.hospital.star), 5),
              ),
              Positioned(
                left: 0,
                bottom: 0,
                child: Container(
                  width: MediaQuery.of(context).size.width - 30,
                  height: 0.5,
                  color: Color(0xffE5E5E5),
                ),
              )
            ],
          ),
        ));
  }

  Widget PlanItem(BuildContext context) {
    if (cards.plan == null && isDebug) {
      throw new Exception();
    }
    String price;
    if (cards.plan.minPrice.empty() && cards.plan.maxPrice.empty()) {
      price = "暂无报价";
    } else if (cards.plan.minPrice.empty() && !cards.plan.maxPrice.empty()) {
      price = "${cards.plan.maxPrice}";
    } else if (!cards.plan.minPrice.empty() && cards.plan.maxPrice.empty()) {
      price = "${cards.plan.minPrice}";
    } else {
      price = "${cards.plan.minPrice}-${cards.plan.maxPrice}";
    }
    return Container(
      height: 118,
      margin: EdgeInsets.only(left: 15, right: 15),
      child: Stack(
        children: <Widget>[
          Positioned(
            left: 0,
            top: 15,
            child: Container(
              width: 210,
              child: baseText(cards.plan.planName, 15, Color(0xff282828),
                  bold: true),
            ),
          ),
          Positioned(
            right: 0,
            top: 15,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.end,
              children: <Widget>[
                price == "暂无报价"
                    ? Container(
                        width: 0,
                        height: 0,
                      )
                    : baseText("¥", 12, Color(0xffFF5963)),
                baseText(price, price == "暂无报价" ? 13 : 15,
                    price == "暂无报价" ? Color(0xff999999) : Color(0xffFF5963),
                    bold: price != "暂无报价")
              ],
            ),
          ),
          Positioned(
            left: 4.5,
            bottom: 25,
            child: compareWidget(),
          ),
          Positioned(bottom: 15, right: 0, child: lowPriceWidget()),
          Positioned(
            right: 137,
            bottom: 15,
            child: askWidget(),
          ),
          Positioned(
            top: 40,
            right: 0,
            child: baseText(
                "指导价：${cards.plan.guide_price}", 11, Color(0xff666666)),
          ),
          Positioned(
            left: 0,
            bottom: 0,
            child: Container(
              width: MediaQuery.of(context).size.width - 30,
              height: 0.5,
              color: Color(0xffE5E5E5),
            ),
          )
        ],
      ),
    ).gestureDetector(() {
      Map<String, dynamic> buriedMap;
      buriedMap = {
        "tab_name": tabName,
        "position": position,
        "card_id": cards.plan.plan_id,
        "card_name": "card",
        "card_type": "card",
        "transaction_type": "",
        "card_content_type": "level_two_plan"
      };
      RouterCenterImpl()
          .findMainRouter()
          .buriedEvent("on_click_card", buriedMap);

      Map<String, dynamic> map = {
        "business_id": "${cards.plan.plan_id}",
        "planId": cards.plan.plan_id
      };
      RouterCenterImpl()
          .findMainRouter()
          .jumpPage(context, "level_two_plan_deatil", map, false);
    });
  }

  Widget lowPriceWidget() {
    return GestureDetector(
      onTap: lowPrice,
      behavior: HitTestBehavior.opaque,
      child: Container(
        width: 122,
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffFFF5F5)),
        alignment: Alignment.center,
        child: baseText("获取底价", 14, Color(0xffFF5963), bold: true),
      ),
    );
  }

  Widget askWidget() {
    return GestureDetector(
      onTap: ask,
      behavior: HitTestBehavior.opaque,
      child: Container(
        width: 122,
        height: 37,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(18.5),
            color: Color(0xffEEFDFD)),
        alignment: Alignment.center,
        child: baseText("咨询", 14, Color(0xff3FB5AF), bold: true),
      ),
    );
  }

  Widget compareWidget() {
    return Row(
      mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: <Widget>[
        Container(
          width: 18,
          height: 18,
          child: Image.asset("assets/vs.png"),
        ),
        Container(
          margin: EdgeInsets.only(left: 1.5),
          child: baseText("去比较", 13, Color(0xff282828), bold: true),
        )
      ],
    ).gestureDetector(() {
      compare(cards.plan.plan_id);
    });
  }

  Widget DiaryItem(BuildContext context) {
    if (cards.diary == null && isDebug) {
      throw new Exception();
    }
    return Container(
      margin: EdgeInsets.only(left: 20, right: 20),
      width: double.maxFinite,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(top: 15),
            height: 25,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  width: 25,
                  height: 25,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      imageUrl: cards.diary.user.portrait,
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(left: 8),
                  child: baseText(
                      cards.diary.user.userName, 13, Color(0xff999999)),
                ),
                cards.diary.userLevel != null &&
                        cards.diary.userLevel.levelIcon != null
                    ? Container(
                        width: 31,
                        height: 12,
                        child: CachedNetworkImage(
                          imageUrl: cards.diary.userLevel.levelIcon,
                        ),
                      )
                    : Container(
                        width: 0,
                      )
              ],
            ),
          ),
          (cards.diary.images == null ||
                  cards.diary.images.isEmpty ||
                  cards.diary.images.length < 2)
              ? Container(
                  height: 0,
                )
              : Container(
                  margin: EdgeInsets.only(top: 12),
                  height: 163,
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: Container(
                          decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(4),
                              image: DecorationImage(
                                  fit: BoxFit.cover,
                                  image: NetworkImage(
                                      cards.diary.images[0].imageHalf))),
                          alignment: Alignment.bottomLeft,
                          child: Container(
                            width: 65.5,
                            height: 18,
                            decoration: BoxDecoration(
                                color: Color(0x4c000000),
                                borderRadius: BorderRadius.only(
                                  bottomLeft: Radius.circular(4),
                                  topRight: Radius.circular(2),
                                )),
                            alignment: Alignment.center,
                            child: baseText(
                                cards.diary.images[0].desc, 11, Colors.white),
                          ),
                        ),
                      ),
                      Container(
                        width: 9,
                      ),
                      Expanded(
                        child: Container(
                          decoration: BoxDecoration(
                              image: DecorationImage(
                                  fit: BoxFit.cover,
                                  image: NetworkImage(
                                      cards.diary.images[1].imageHalf))),
                          alignment: Alignment.bottomLeft,
                          child: Container(
                            width: 65.5,
                            height: 18,
                            decoration: BoxDecoration(
                                color: Color(0x4c000000),
                                borderRadius: BorderRadius.only(
                                  bottomLeft: Radius.circular(4),
                                  topRight: Radius.circular(2),
                                )),
                            alignment: Alignment.center,
                            child: baseText(
                                cards.diary.images[1].desc, 11, Colors.white),
                          ),
                        ),
                      )
                    ],
                  )),
          Container(
            margin: EdgeInsets.only(top: 12.5, bottom: 12),
            child: Text(
              cards.diary.content,
              textScaleFactor: 1.0,
              maxLines: 5,
              strutStyle: StrutStyle(forceStrutHeight: true, height: 2),
              overflow: TextOverflow.ellipsis,
              style: TextStyle(
                  decoration: TextDecoration.none,
                  fontSize: 15,
                  color: Color(0xff464646),
                  fontStyle: FontStyle.normal,
                  fontWeight: FontWeight.w400),
            ),
          ),
          baseText("项目${cards.diary.title}", 13, Color(0xff999999)),
          Container(
            margin: EdgeInsets.only(top: 12, bottom: 16),
            height: 14,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/eye.png"),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5, right: 20),
                  child:
                      baseText("${cards.diary.viewNum}", 12, Color(0xff999999)),
                ),
                Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/arguement.png"),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5, right: 20),
                  child: baseText(
                      "${cards.diary.replyNum}", 12, Color(0xff999999)),
                ),
                Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/heart.png"),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5, right: 20),
                  child:
                      baseText("${cards.diary.voteNum}", 12, Color(0xff999999)),
                )
              ],
            ),
          ),
          Container(
            width: double.maxFinite,
            height: 0.5,
            color: Color(0xffE5E5E5),
          )
        ],
      ),
    ).gestureDetector(() {
      RouterCenterImpl().findMainRouter().jumpPage(context,
          "gengmei://diary?diary_id=${cards.diary.diaryId}", null, true);
    });
  }
}
