/*
 * @Author: zx 
 * @Date: 2020-06-30 19:31:32 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-01 20:31:42
 */
class PlanCompareDetail {
  int error;
  String message;
  Map extra;
  int errorCode;
  Map errorExtra;
  Data data;
  UserType userType;

  PlanCompareDetail(
      {this.error,
      this.message,
      this.extra,
      this.errorCode,
      this.errorExtra,
      this.data,
      this.userType});

  PlanCompareDetail.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorCode = json['error_code'];
    errorExtra = json['error_extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_code'] = this.errorCode;
    data['error_extra'] = this.errorExtra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    return data;
  }
}

class Data {
  List<PlansInfoDetail> plansInfo;
  List<Groups> groups;

  Data({this.plansInfo, this.groups});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['plans_info'] != null) {
      plansInfo = new List<PlansInfoDetail>();
      json['plans_info'].forEach((v) {
        plansInfo.add(new PlansInfoDetail.fromJson(v));
      });
    }
    if (json['groups'] != null) {
      groups = new List<Groups>();
      json['groups'].forEach((v) {
        groups.add(new Groups.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.plansInfo != null) {
      data['plans_info'] = this.plansInfo.map((v) => v.toJson()).toList();
    }
    if (this.groups != null) {
      data['groups'] = this.groups.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class PlansInfoDetail {
  int planId;
  String planName;
  String price;

  PlansInfoDetail({this.planId, this.planName, this.price});

  PlansInfoDetail.fromJson(Map<String, dynamic> json) {
    planId = json['plan_id'];
    planName = json['plan_name'];
    price = json['price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['plan_id'] = this.planId;
    data['plan_name'] = this.planName;
    data['price'] = this.price;
    return data;
  }
}

class Groups {
  String groupType;
  String groupName;
  List<Plans> plans;

  Groups({this.groupType, this.groupName, this.plans});

  Groups.fromJson(Map<String, dynamic> json) {
    groupType = json['group_type'];
    groupName = json['group_name'];
    if (json['plans'] != null) {
      plans = new List<Plans>();
      json['plans'].forEach((v) {
        plans.add(new Plans.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['group_type'] = this.groupType;
    data['group_name'] = this.groupName;
    if (this.plans != null) {
      data['plans'] = this.plans.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Plans {
  int planId;
  List<Attrs> attrs;
  String positiveRate;
  String salesCount;
  int planStart;

  Plans({this.planId, this.attrs});

  Plans.fromJson(Map<String, dynamic> json) {
    planId = json['plan_id'];
    positiveRate = json['positive_rate'];
    salesCount = json['sales_count'];
    planStart = json['plan_start'];
    if (json['attrs'] != null) {
      attrs = new List<Attrs>();
      json['attrs'].forEach((v) {
        attrs.add(new Attrs.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['plan_id'] = this.planId;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    data['plan_start'] = this.planStart;
    if (this.attrs != null) {
      data['attrs'] = this.attrs.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Attrs {
  String attrName;
  String attrValue;

  Attrs({this.attrName, this.attrValue});

  Attrs.fromJson(Map<String, dynamic> json) {
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}
