library md2_tab_indicator;

import 'package:flutter/widgets.dart';

class BaseIndicator extends Decoration {
  double indicatorHeight;

  Color indicatorColor;

  double indicatorRadius;

  double indicatorWidth;

  double indicatorPaddingBottom;

  BaseIndicator(
      {this.indicatorHeight,
      this.indicatorColor,
      this.indicatorRadius,
      this.indicatorWidth,
      this.indicatorPaddingBottom}) {
    indicatorHeight = indicatorHeight ?? 3.0;
    indicatorColor = indicatorColor ?? Color(0xff3FB5AF);
    indicatorRadius = indicatorRadius ?? 1.5;
    indicatorWidth = indicatorWidth ?? 22.0;
    indicatorPaddingBottom = indicatorPaddingBottom ?? 6.0;
  }

  @override
  _MD2Painter createBoxPainter([VoidCallback onChanged]) {
    return new _MD2Painter(this, onChanged);
  }
}

class _MD2Painter extends BoxPainter {
  final BaseIndicator decoration;

  _MD2Painter(this.decoration, VoidCallback onChanged)
      : assert(decoration != null),
        super(onChanged);

  @override
  void paint(Canvas canvas, Offset offset, ImageConfiguration configuration) {
    assert(configuration != null);
    assert(configuration.size != null);
    double width = (configuration.size.width-50) / 3.0 * 2.0;
    Rect rect = Offset(
            offset.dx +
                configuration.size.width / 2 -
                width / 2,
            (configuration.size.height -
                decoration.indicatorHeight -
                decoration.indicatorPaddingBottom)) &
        Size(width, decoration.indicatorHeight);

    final Paint paint = Paint();
    paint.color = decoration.indicatorColor;
    paint.style = PaintingStyle.fill;
    double radius = decoration.indicatorRadius;
    canvas.drawRRect(
        RRect.fromRectAndCorners(rect,
            topRight: Radius.circular(radius),
            topLeft: Radius.circular(radius),
            bottomLeft: Radius.circular(radius),
            bottomRight: Radius.circular(radius)),
        paint);
  }
}
