/*
 * @author dx
 * @date 2020-06-29
 **/

import 'dart:math';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneItem.dart';
import 'package:gm_flutter/ClueModel/page/levelTwo/LevelTwoModel.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismBoxPage.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

class LevelTwoPage extends StatefulWidget {
  @override
  _LevelTwoPageState createState() => _LevelTwoPageState();
}

class _LevelTwoPageState extends BaseState<LevelTwoPage>
    with SingleTickerProviderStateMixin {
  LevelTwoModel _model = new LevelTwoModel();
  RefreshController _refreshController = RefreshController();
  PageController pageController = new PageController();
  TabController tabController;

  @override
  void initState() {
    super.initState();
    this.tabController = TabController(length: 2, vsync: this);
  }

  @override
  void dispose() {
    _model.dispose();
    pageController.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
        body: Stack(
      children: <Widget>[
        CustomScrollView(slivers: <Widget>[
          SliverAppBar(
            pinned: true,
            elevation: 0,
            expandedHeight: 0,
            flexibleSpace: FlexibleSpaceBar(title: Text('二级方案')),
          ),
          SliverToBoxAdapter(
              child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.max,
            children: <Widget>[good(), rect(), explain()],
          )),
          SliverPersistentHeader(
            pinned: true,
            delegate: StickyTabBarDelegate(
              child: TabBar(
                  labelColor: Color(0xff282828),
                  labelStyle:
                      TextStyle(fontSize: 15.0, fontWeight: FontWeight.bold),
                  unselectedLabelColor: Color(0xffB5B5B5),
                  unselectedLabelStyle: TextStyle(fontSize: 15.0),
                  indicatorColor: Color(0xff4ABAB4),
                  indicatorWeight: 3.0,
                  indicatorSize: TabBarIndicatorSize.label,
                  indicatorPadding: EdgeInsets.only(left: 5.0, right: 5.0),
                  controller: this.tabController,
                  tabs: <Widget>[Tab(text: '医院'), Tab(text: '医生')]),
            ),
          ),
          SliverFillRemaining(
              child: TabBarView(
                  controller: this.tabController,
                  children: <Widget>[pages(), pages()]))
        ]),
        Positioned(left: 0, right: 0, bottom: 0, child: bottomWidget())
      ],
    ));
  }

  Widget good() {
    return StreamBuilder(
      stream: _model.rectLive.stream,
      initialData: ["w", "w", "q", "w"],
      builder: (context, data) {
        return Padding(
          padding: EdgeInsets.only(left: 15.0, right: 15.0, top: 8.0),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.max,
            children: <Widget>[
              ClipRRect(
                  borderRadius: BorderRadius.circular(6),
                  child: Container(
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17),
                        border: Border.all(color: Color(0xffF9F8FB), width: 1)),
                    child: Image.network(
                      'https://img1.gamersky.com/image2019/07/20190725_ll_red_136_2/gamersky_07small_14_201972510258D0.jpg',
                      width: 86,
                      height: 86,
                      fit: BoxFit.cover,
                    ),
                  )),
              Padding(
                  padding: EdgeInsets.only(left: 12, top: 5),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisSize: MainAxisSize.max,
                    children: <Widget>[
                      Text('乔雅登玻尿酸（药品类）',
                          style: TextStyle(
                              color: Color(0xff333333),
                              fontSize: 15,
                              fontWeight: FontWeight.bold)),
                      Padding(padding: EdgeInsets.only(top: 5)),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        verticalDirection: VerticalDirection.up,
                        children: <Widget>[
                          Text('指导价：',
                              style: TextStyle(
                                  color: Color(0xff999999), fontSize: 12)),
                          Text(
                            '¥2000-5000',
                            style: TextStyle(
                                color: Color(0xffFF5963), fontSize: 12),
                          )
                        ],
                      )
                    ],
                  )),
            ],
          ),
        );
      },
    );
  }

  Widget rect() {
    return Padding(
      padding: EdgeInsets.only(top: 20),
      child: StreamBuilder<List<String>>(
        stream: _model.rectLive.stream,
        initialData: ["w", "w", "q", "w", "w", "w", "q", "w"],
        builder: (c, data) {
          List<Widget> list = List();
          for (int i = 0; i < data.data.length; i += 2) {
            list.add(Expanded(
              child: Container(
                alignment: Alignment.center,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: <Widget>[
                    baseText(data.data[i], 14, Color(0xff282828), bold: true),
                    baseText(data.data[i + 1], 11, Color(0xff999999)),
                  ],
                ),
              ),
            ));
            if (i < data.data.length - 2) {
              list.add(Container(
                width: 0.5,
                height: 18,
                color: Color(0xFFE5E5E5),
              ));
            }
          }
          return Container(
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(4),
              color: Color(0xffF9F8FB),
            ),
            width: double.maxFinite,
            height: 62,
            margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: list,
            ),
          );
        },
      ),
    );
  }

  Widget explain() {
    return StreamBuilder<List<String>>(
      stream: _model.explainLive.stream,
      initialData: ["www", "www", "www", "??"],
      builder: (c, data) {
        List<Widget> list = [];
        list.add(Container(
          height: 31,
          child: Row(
            children: <Widget>[
              baseText("项目说明", 15, Color(0xff282828)),
              Expanded(
                child: Container(),
              ),
              GestureDetector(
                onTap: () {
                  //TODO
                },
                behavior: HitTestBehavior.opaque,
                child: baseText("了解更多", 12, Color(0xff3FB5AF)),
              )
            ],
          ),
        ));
        for (int i = 0; i < data.data.length; i += 2) {
          list.add(Container(
            height: 28,
            child: Row(
              children: <Widget>[
                baseText(data.data[i], 13, Color(0xff999999)),
                Container(
                  margin: EdgeInsets.only(left: 12),
                  child: baseText(data.data[i + 1], 13, Color(0xff666666)),
                )
              ],
            ),
          ));
        }
        return Container(
          margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: list,
          ),
        );
      },
    );
  }

  Widget bottomWidget() {
    return Container(
      width: double.maxFinite,
      height: 55,
      child: Row(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(left: 18),
            width: 30,
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Container(
                  width: 22,
                  height: 22,
                  child: Image.asset("assets/vs_black.png"),
                ),
                Container(
                  margin: EdgeInsets.only(top: 3),
                  child: baseText("去比较", 10, Color(0xff282828)),
                )
              ],
            ),
          ),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {
                BaseBottomPicker()
                  ..setPicker(MechanismBox())
                  ..show(context);
              },
              child: Container(
                margin: EdgeInsets.only(left: 15),
                width: 135,
                height: 40,
                decoration: BoxDecoration(
                    color: Color(0xff51CDC7),
                    borderRadius: BorderRadius.circular(20)),
                alignment: Alignment.center,
                child: baseText("咨询", 14, Colors.white, bold: true),
              )),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {},
              child: Container(
                margin: EdgeInsets.only(left: 15),
                width: 135,
                height: 40,
                decoration: BoxDecoration(
                    color: Color(0xffF96079),
                    borderRadius: BorderRadius.circular(20)),
                alignment: Alignment.center,
                child: baseText("获取底价", 14, Colors.white, bold: true),
              )),
          Expanded(
            child: Container(),
          )
        ],
      ),
    );
  }

  Widget pages() {
    return Container(
        margin: EdgeInsets.only(top: 5),
        width: double.maxFinite,
        child: ListView.builder(
          physics: NeverScrollableScrollPhysics(),
          itemBuilder: (c, index) {
            return Text('$index');
          },
          itemCount: 5,
        ));
  }
}

Widget DoctorItem(BuildContext context, cards) {
  if (cards.doctor == null && isDebug) {
    throw new Exception();
  }
  return GestureDetector(
    child: Container(
      margin: EdgeInsets.only(left: 15, right: 15),
      height: 127,
      child: Stack(
        children: <Widget>[
          Positioned(
            top: 15,
            child: Container(
              width: 45,
              height: 45,
              child: ClipOval(
                child: CachedNetworkImage(
                  imageUrl: cards.doctor.portrait,
                ),
              ),
            ),
          ),
          Positioned(
            left: 57,
            top: 18,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.end,
              children: <Widget>[
                baseText(cards.doctor.name, 15, Color(0xff333333), bold: true),
                Container(
                  margin: EdgeInsets.only(left: 4),
                  child: baseText(cards.doctor.name, 15, Color(0xff333333),
                      bold: true),
                )
              ],
            ),
          ),
          Positioned(
            top: 42,
            right: 0,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.end,
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                baseText("¥", 12, Color(0xffFF5963)),
                baseText("${cards.doctor.minPrice}-${cards.doctor.maxPrice}",
                    15, Color(0xffFF5963)),
              ],
            ),
          ),
          Positioned(
            bottom: 15,
            right: 0,
            child: lowPriceWidget(),
          ),
          Positioned(
            bottom: 15,
            right: 187,
            child: askWidget(),
          ),
        ],
      ),
    ),
  );
}

Widget HospitalItem(BuildContext context, cards) {
  if (cards.hospital == null && isDebug) {
    throw new Exception();
  }
  return GestureDetector(
      onTap: () {},
      child: Container(
        margin: EdgeInsets.only(left: 15, right: 15),
        height: 149,
        child: Stack(
          children: <Widget>[
            Positioned(
              left: 0,
              top: 15,
              child: Container(
                width: 45,
                height: 45,
                child: ClipOval(
                  child: CachedNetworkImage(
                    imageUrl: cards.hospital.portrait,
                  ),
                ),
              ),
            ),
            Positioned(
              left: 57,
              top: 17.5,
              child: baseText(cards.hospital.name, 15, Color(0xff333333),
                  bold: true),
            ),
            Positioned(
              top: 42.5,
              right: 0,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.end,
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  baseText("¥", 12, Color(0xffFF5963)),
                  baseText(
                      "${cards.hospital.minPrice}-${cards.hospital.maxPrice}",
                      15,
                      Color(0xffFF5963)),
                ],
              ),
            ),
            Positioned(
              bottom: 15,
              right: 0,
              child: lowPriceWidget(),
            ),
            Positioned(
              bottom: 15,
              right: 187,
              child: askWidget(),
            ),
            Positioned(
              bottom: 67,
              left: 57,
              child: baseText(cards.hospital.address, 12, Color(0xff666666)),
            ),
            Positioned(
              left: 57,
              top: 43.5,
              child: FiveStarView(cards.hospital.star, 5),
            )
          ],
        ),
      ));
}

Widget lowPriceWidget() {
  return GestureDetector(
    behavior: HitTestBehavior.opaque,
    child: Container(
      width: 122,
      height: 37,
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(18.5), color: Color(0xffFFF5F5)),
      alignment: Alignment.center,
      child: baseText("获取底价", 14, Color(0xffFF5963), bold: true),
    ),
  );
}

Widget askWidget() {
  return GestureDetector(
    behavior: HitTestBehavior.opaque,
    child: Container(
      width: 122,
      height: 37,
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(18.5), color: Color(0xffEEFDFD)),
      alignment: Alignment.center,
      child: baseText("咨询", 14, Color(0xff3FB5AF), bold: true),
    ),
  );
}

class StickyTabBarDelegate extends SliverPersistentHeaderDelegate {
  final TabBar child;

  StickyTabBarDelegate({@required this.child});

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    return this.child;
  }

  @override
  double get maxExtent => this.child.preferredSize.height;

  @override
  double get minExtent => this.child.preferredSize.height;

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) {
    return true;
  }
}
