/*
 * @author lsy
 * @date   2020/7/2
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/levelTwo/LevelTwoPage.dart';
import 'package:gm_flutter/ClueModel/page/top/TopModel.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/view/baseTabIndicator.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class TopPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => TopPageState();
}

class TopPageState extends BaseState<TopPage> with TickerProviderStateMixin {
  RefreshController refreshController = RefreshController();
  TabController tabController;
  TopModel _model = TopModel();

  @override
  void initState() {
    tabController = TabController(length: 4, vsync: this);
    super.initState();
  }

  @override
  void dispose() {
    refreshController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      body: home(),
    );
  }

  Widget home() {
    return baseRefreshView(refreshController, () {}, null, null,
        customScrollView: CustomScrollView(slivers: <Widget>[
          SliverAppBar(
            pinned: true,
            elevation: 0,
            expandedHeight: 0,
            flexibleSpace: FlexibleSpaceBar(title: Text('二级方案')),
          ),
          SliverToBoxAdapter(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisSize: MainAxisSize.max,
                children: <Widget>[
                  Container(
                    height: 50,
                  )
                ],
              )),
          SliverPersistentHeader(
            pinned: true,
            delegate: StickyTabBarDelegate(
                child: baseTabBar(tabController, getTabs(), (index) {
                  _model.selectTab(index);
                })),
          ),
          SliverFillRemaining(
              child: TabBarView(controller: tabController, children: <Widget>[
                Container(
                  color: Colors.red,
                ),
                Container(
                  color: Colors.red,
                ),
                Container(
                  color: Colors.red,
                ),
                Container(
                  color: Colors.blue,
                )
              ]))
        ]));
  }

  List<Widget> getTabs() {
    List<Widget> list = [];

    for (int i = 0; i < _model.tabs.length; i++) {
      list.add( Container(
        height: 40,
        width: 50,
        color: Colors.red,
      ));
//      list.add(baseTabBarItem(_model.tabs[i],
//          leftPadding: i == 0 ? 24 : 28,
//          color: i == _model.tabIndex ? Color(0xff282828) : Color(0xffB5B5B5)));
    }
    return list;
  }
}
