/*
 * @author lsy
 * @date   2020/7/6
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/commonModel/util/JumpUtil.dart';
import 'package:gm_flutter/MainRouter/manager/MainManager.dart';
import 'package:gm_flutter/commonModel/App.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/main.mark.dart';

class JumpManager {
  static JumpManager _instance;

  JumpManager._() {}

  static JumpManager instance() {
    if (_instance == null) {
      _instance = JumpManager._();
    }
    return _instance;
  }

  void jumpToPage(BuildContext context, String pageName,
      Map<String, dynamic> params, bool nativePage) {
    String pageNameWrap =
        nativePage ? "gm://${pageName}" : "flutter://${pageName}";
    if (!MainManager.getInstance().isInit) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(COOKIE,
          "_gtid=3123e178b91a11eaa2d87e40d376ac134112; sessionid=pq9wf8equ4h26ia3yspzmquqn2rjs6mx; _gm_token=4091a81593419225");
      JumpUtil.jumpToPageRight(context, initMap(params)[pageNameWrap]);
    } else {
      FlutterBoost.singleton.open(pageName, urlParams: params);
    }
  }

  Map<String, dynamic> initMap(Map<String, dynamic> params) {
    return {
      "flutter://level_one_plan_detail":
          RouterCenterImpl().findClueRouter().getLevelOnePage(params),
      "flutter://level_one_plan_instruction":
          RouterCenterImpl().findClueRouter().getProjectDetailsPage(params),
      "flutter://level_one_plan_compare":
          RouterCenterImpl().findClueRouter().getPlansCompareFeed(params),
      "flutter://plan_home": RouterCenterImpl().findClueRouter().getPlanPage(),
      "flutter://favor_plan": RouterCenterImpl().findClueRouter().getTopPage(params),
      "flutter://hot_plan": RouterCenterImpl().findClueRouter().getTopPage(params),
    };
  }
}
