/*
 * @author lsy
 * @date   2020/6/29
 **/

import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/ConsultHospitalsBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class MechanismModel extends BaseModel {
  LiveData<List<String>> questionsLive = LiveData();

  LiveData<int> stateLive = LiveData();
  LiveData messageLive = LiveData();
  RxDispose rxDispose = RxDispose();

  List<String> doctor_ids = new List();
  List<String> hospital_ids = new List();

  int plan_id;
  String tab_type;
  int page = 1;

  LiveData<int> levelStateLive = LiveData();
  LiveData<List<Hospitals>> cardsLive = LiveData();
  List<Hospitals> data = [];

  void refreshView(bool clear, {RefreshController refreshListener}) {
    if (clear) {
      data.clear();
      page = 1;
    }
    ClueApiImpl.getInstance()
        .getLevelMechanismList(DioUtil.getInstance().getDio(), plan_id, page)
        .listen((event) {
          if (event.error == 0) {
            if ((event.data.hospitals == null ||
                event.data.hospitals.isEmpty)) {
              if (page == 1) {
                levelStateLive.notifyView(EMPTY);
              } else {
                cardsLive.notifyView([]);
              }
            } else {
              if (page == 1) {
                for (var i = 0; i < event.data.hospitals.length; i++) {
                  if (i < 3) {
                    event.data.hospitals[i].isCheck = true;
                    doctor_ids.add(event.data.hospitals[i].doctorId);
                    hospital_ids.add(event.data.hospitals[i].hospitalId);
                  }
                }
              }
              data.addAll(event.data.hospitals);
              cardsLive.notifyView(data);
              levelStateLive.notifyView(ENDLOADING);
            }
          } else {
            NativeToast.showNativeToast(event.message);
            levelStateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          levelStateLive.notifyView(FAIL);
        });
  }

  getQuestions(int plan_id) {
    ClueApiImpl.getInstance()
        .getConsultQuestions(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            stateLive.notifyView(ENDLOADING);
            questionsLive.notifyView(event.data.questions);
          } else {
            stateLive.notifyView(FAIL);
            questionsLive.notifyView(null);
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          stateLive.notifyView(FAIL);
          questionsLive.notifyView(null);
          PrintUtil.printBug(err);
        });
  }

  sendMessage(String doctor_ids, String hospital_ids, String question,
      int plan_id, Function(int state) func) {
    ClueApiImpl.getInstance()
        .sendMessage(DioUtil.getInstance().getDio(), doctor_ids, hospital_ids,
            question, plan_id)
        .listen((event) {
          if (event.error == 0) {
            func(0);
            messageLive.notifyView(event.data.success);
          } else {
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
        });
  }

  @override
  void dispose() {
    questionsLive.dispost();
    stateLive.dispost();
    rxDispose.dispose();
    levelStateLive.dispost();
    cardsLive.dispost();
  }

  void loadMore() {
    page++;
    refreshView(false);
  }
}
