/*
 * @author lsy
 * @date   2020/6/29
 **/
class LevelOneFeedList {
  int error;
  String message;
  Map extra;
  Map errorExtra;
  UserType userType;
  Data data;

  LevelOneFeedList(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  LevelOneFeedList.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  List<Cards> cards;

  Data({this.cards});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['cards'] != null) {
      cards = new List<Cards>();
      json['cards'].forEach((v) {
        cards.add(new Cards.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.cards != null) {
      data['cards'] = this.cards.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Cards {
  String cardType;
  Plan plan;
  Hospital hospital;
  Doctor doctor;
  Diary diary;

  Cards({this.cardType, this.plan, this.hospital, this.doctor, this.diary});

  Cards.fromJson(Map<String, dynamic> json) {
    cardType = json['card_type'];
    plan = json['plan'] != null ? new Plan.fromJson(json['plan']) : null;
    hospital = json['hospital'] != null
        ? new Hospital.fromJson(json['hospital'])
        : null;
    doctor =
        json['doctor'] != null ? new Doctor.fromJson(json['doctor']) : null;
    diary = json['diary'] != null ? new Diary.fromJson(json['diary']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['card_type'] = this.cardType;
    if (this.plan != null) {
      data['plan'] = this.plan.toJson();
    }
    if (this.hospital != null) {
      data['hospital'] = this.hospital.toJson();
    }
    if (this.doctor != null) {
      data['doctor'] = this.doctor.toJson();
    }
    if (this.diary != null) {
      data['diary'] = this.diary.toJson();
    }
    return data;
  }
}

class Plan {
  int plan_id;
  String planName;
  String minPrice;
  String maxPrice;
  String positiveRate;
  String salesCount;
  List<BaseAttrs> baseAttrs;
  String projectImage;
  String consultType;
  String messageUrl;
  String guide_price;

  Plan(
      {this.planName,
      this.minPrice,
      this.maxPrice,
      this.positiveRate,
      this.salesCount,
      this.baseAttrs,
      this.projectImage,
      this.consultType,
      this.messageUrl});

  Plan.fromJson(Map<String, dynamic> json) {
    planName = json['plan_name'];
    plan_id = json['plan_id'];
    minPrice = json['min_price'];
    maxPrice = json['max_price'];
    positiveRate = json['positive_rate'];
    guide_price = json['guide_price'];
    salesCount = json['sales_count'];
    if (json['base_attrs'] != null) {
      baseAttrs = new List<BaseAttrs>();
      json['base_attrs'].forEach((v) {
        baseAttrs.add(new BaseAttrs.fromJson(v));
      });
    }
    projectImage = json['project_image'];
    consultType = json['consult_type'];
    messageUrl = json['message_url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['plan_name'] = this.planName;
    data['min_price'] = this.minPrice;
    data['guide_price'] = this.guide_price;
    data['max_price'] = this.maxPrice;
    data['plan_id'] = this.plan_id;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    if (this.baseAttrs != null) {
      data['base_attrs'] = this.baseAttrs.map((v) => v.toJson()).toList();
    }
    data['project_image'] = this.projectImage;
    data['consult_type'] = this.consultType;
    data['message_url'] = this.messageUrl;
    return data;
  }
}

class BaseAttrs {
  String attrName;
  String attrValue;

  BaseAttrs({this.attrName, this.attrValue});

  BaseAttrs.fromJson(Map<String, dynamic> json) {
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}

class Hospital {
  String portrait;
  String hosiptalId;
  String name;
  String minPrice;
  String maxPrice;
  String star;
  String address;
  String consultType;
  String messageUrl;
  bool isCheck = false;

  Hospital(
      {this.portrait,
      this.name,
      this.minPrice,
      this.maxPrice,
      this.star,
      this.address,
      this.consultType,
      this.messageUrl});

  Hospital.fromJson(Map<String, dynamic> json) {
    portrait = json['portrait'];
    hosiptalId = json['hospital_id'];
    name = json['name'];
    minPrice = json['min_price'];
    maxPrice = json['max_price'];
    star = json['star'];
    address = json['address'];
    consultType = json['consult_type'];
    messageUrl = json['message_url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['portrait'] = this.portrait;
    data['hospital_id'] = this.hosiptalId;
    data['name'] = this.name;
    data['min_price'] = this.minPrice;
    data['max_price'] = this.maxPrice;
    data['star'] = this.star;
    data['address'] = this.address;
    data['consult_type'] = this.consultType;
    data['message_url'] = this.messageUrl;
    return data;
  }
}

class Doctor {
  String portrait;
  String name;
  String doctor_id;
  String minPrice;
  String maxPrice;
  String star;
  String title;
  String consultType;
  String messageUrl;

  Doctor(
      {this.portrait,
      this.name,
      this.minPrice,
      this.maxPrice,
      this.star,
      this.title,
      this.consultType,
      this.messageUrl});

  Doctor.fromJson(Map<String, dynamic> json) {
    portrait = json['portrait'];
    name = json['name'];
    minPrice = json['min_price'];
    maxPrice = json['max_price'];
    doctor_id = json['doctor_id'];
    star = json['star'];
    title = json['title'];
    consultType = json['consult_type'];
    messageUrl = json['message_url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['portrait'] = this.portrait;
    data['name'] = this.name;
    data['doctor_id'] = this.doctor_id;
    data['min_price'] = this.minPrice;
    data['max_price'] = this.maxPrice;
    data['star'] = this.star;
    data['title'] = this.title;
    data['consult_type'] = this.consultType;
    data['message_url'] = this.messageUrl;
    return data;
  }
}

class Diary {
  int diaryNum;
  String videoUrl;
  bool isIdentification;
  bool isLiked;
  String titleStyleType;
  int replyNum;
  int lasestTopicCreatedTime;
  List<Images> images;
  UserType relationServiceSku;
  String createdTime;
  int latestTopicId;
  int id;
  String city;
  int userId;
  String title;
  bool isVoted;
  int diaryId;
  List<String> preImageList;
  int voteNum;
  List<TagsNewEra> tagsNewEra;
  String content;
  String videoPic;
  String shortVideoUrl;
  int diaryAmount;
  String diaryTitle;
  String authorType;
  List<Tags> tags;
  String contentLevel;
  int lastModified;
  User user;
  bool isOnline;
  String date;
  String membershipLevel;
  String viewNum;
  List<String> postImageList;
  UserLevel userLevel;
  int serviceId;

  Diary(
      {this.diaryNum,
      this.videoUrl,
      this.isIdentification,
      this.isLiked,
      this.titleStyleType,
      this.replyNum,
      this.lasestTopicCreatedTime,
      this.images,
      this.relationServiceSku,
      this.createdTime,
      this.latestTopicId,
      this.id,
      this.city,
      this.userId,
      this.title,
      this.isVoted,
      this.diaryId,
      this.preImageList,
      this.voteNum,
      this.tagsNewEra,
      this.content,
      this.videoPic,
      this.shortVideoUrl,
      this.diaryAmount,
      this.diaryTitle,
      this.authorType,
      this.tags,
      this.contentLevel,
      this.lastModified,
      this.user,
      this.isOnline,
      this.date,
      this.membershipLevel,
      this.viewNum,
      this.postImageList,
      this.userLevel,
      this.serviceId});

  Diary.fromJson(Map<String, dynamic> json) {
    diaryNum = json['diary_num'];
    videoUrl = json['video_url'];
    isIdentification = json['is_identification'];
    isLiked = json['is_liked'];
    titleStyleType = json['title_style_type'];
    replyNum = json['reply_num'];
    lasestTopicCreatedTime = json['lasest_topic_created_time'];
    if (json['images'] != null) {
      images = new List<Images>();
      json['images'].forEach((v) {
        images.add(new Images.fromJson(v));
      });
    }
    relationServiceSku = json['relation_service_sku'] != null
        ? new UserType.fromJson(json['relation_service_sku'])
        : null;
    createdTime = json['created_time'];
    latestTopicId = json['latest_topic_id'];
    id = json['id'];
    city = json['city'];
    userId = json['user_id'];
    title = json['title'];
    isVoted = json['is_voted'];
    diaryId = json['diary_id'];
    preImageList = json['pre_image_list'].cast<String>();
    voteNum = json['vote_num'];
    if (json['tags_new_era'] != null) {
      tagsNewEra = new List<TagsNewEra>();
      json['tags_new_era'].forEach((v) {
        tagsNewEra.add(new TagsNewEra.fromJson(v));
      });
    }
    content = json['content'];
    videoPic = json['video_pic'];
    shortVideoUrl = json['short_video_url'];
    diaryAmount = json['diary_amount'];
    diaryTitle = json['diary_title'];
    authorType = json['author_type'];
    if (json['tags'] != null) {
      tags = new List<Tags>();
      json['tags'].forEach((v) {
        tags.add(new Tags.fromJson(v));
      });
    }
    contentLevel = json['content_level'];
    lastModified = json['last_modified'];
    user = json['user'] != null ? new User.fromJson(json['user']) : null;
    isOnline = json['is_online'];
    date = json['date'];
    membershipLevel = json['membership_level'];
    viewNum = json['view_num'];
    postImageList = json['post_image_list'].cast<String>();
    userLevel = json['user_level'] != null
        ? new UserLevel.fromJson(json['user_level'])
        : null;
    serviceId = json['service_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['diary_num'] = this.diaryNum;
    data['video_url'] = this.videoUrl;
    data['is_identification'] = this.isIdentification;
    data['is_liked'] = this.isLiked;
    data['title_style_type'] = this.titleStyleType;
    data['reply_num'] = this.replyNum;
    data['lasest_topic_created_time'] = this.lasestTopicCreatedTime;
    if (this.images != null) {
      data['images'] = this.images.map((v) => v.toJson()).toList();
    }
    if (this.relationServiceSku != null) {
      data['relation_service_sku'] = this.relationServiceSku.toJson();
    }
    data['created_time'] = this.createdTime;
    data['latest_topic_id'] = this.latestTopicId;
    data['id'] = this.id;
    data['city'] = this.city;
    data['user_id'] = this.userId;
    data['title'] = this.title;
    data['is_voted'] = this.isVoted;
    data['diary_id'] = this.diaryId;
    data['pre_image_list'] = this.preImageList;
    data['vote_num'] = this.voteNum;
    if (this.tagsNewEra != null) {
      data['tags_new_era'] = this.tagsNewEra.map((v) => v.toJson()).toList();
    }
    data['content'] = this.content;
    data['video_pic'] = this.videoPic;
    data['short_video_url'] = this.shortVideoUrl;
    data['diary_amount'] = this.diaryAmount;
    data['diary_title'] = this.diaryTitle;
    data['author_type'] = this.authorType;
    if (this.tags != null) {
      data['tags'] = this.tags.map((v) => v.toJson()).toList();
    }
    data['content_level'] = this.contentLevel;
    data['last_modified'] = this.lastModified;
    if (this.user != null) {
      data['user'] = this.user.toJson();
    }
    data['is_online'] = this.isOnline;
    data['date'] = this.date;
    data['membership_level'] = this.membershipLevel;
    data['view_num'] = this.viewNum;
    data['post_image_list'] = this.postImageList;
    if (this.userLevel != null) {
      data['user_level'] = this.userLevel.toJson();
    }
    data['service_id'] = this.serviceId;
    return data;
  }
}

class Images {
  String imageWide;
  int imageType;
  String image;
  String sImagePlatform;
  String imageSlimwidth;
  String smallWide;
  String imageThumb;
  String imageHalf;
  String desc;

  Images(
      {this.imageWide,
      this.imageType,
      this.image,
      this.sImagePlatform,
      this.imageSlimwidth,
      this.smallWide,
      this.imageThumb,
      this.imageHalf,
      this.desc});

  Images.fromJson(Map<String, dynamic> json) {
    imageWide = json['image_wide'];
    imageType = json['image_type'];
    image = json['image'];
    sImagePlatform = json['_image_platform'];
    imageSlimwidth = json['image_slimwidth'];
    smallWide = json['small_wide'];
    imageThumb = json['image_thumb'];
    imageHalf = json['image_half'];
    desc = json['desc'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['image_wide'] = this.imageWide;
    data['image_type'] = this.imageType;
    data['image'] = this.image;
    data['_image_platform'] = this.sImagePlatform;
    data['image_slimwidth'] = this.imageSlimwidth;
    data['small_wide'] = this.smallWide;
    data['image_thumb'] = this.imageThumb;
    data['image_half'] = this.imageHalf;
    data['desc'] = this.desc;
    return data;
  }
}

class TagsNewEra {
  String type;
  String name;
  int tagId;
  int id;

  TagsNewEra({this.type, this.name, this.tagId, this.id});

  TagsNewEra.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    name = json['name'];
    tagId = json['tag_id'];
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['type'] = this.type;
    data['name'] = this.name;
    data['tag_id'] = this.tagId;
    data['id'] = this.id;
    return data;
  }
}

class User {
  String city;
  int userId;
  int topicNumPosted;
  int voteNumGained;
  String portrait;
  String userName;
  String membershipLevel;

  User(
      {this.city,
      this.userId,
      this.topicNumPosted,
      this.voteNumGained,
      this.portrait,
      this.userName,
      this.membershipLevel});

  User.fromJson(Map<String, dynamic> json) {
    city = json['city'];
    userId = json['user_id'];
    topicNumPosted = json['topic_num_posted'];
    voteNumGained = json['vote_num_gained'];
    portrait = json['portrait'];
    userName = json['user_name'];
    membershipLevel = json['membership_level'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['city'] = this.city;
    data['user_id'] = this.userId;
    data['topic_num_posted'] = this.topicNumPosted;
    data['vote_num_gained'] = this.voteNumGained;
    data['portrait'] = this.portrait;
    data['user_name'] = this.userName;
    data['membership_level'] = this.membershipLevel;
    return data;
  }
}

class UserLevel {
  String levelIcon;
  String constellationIcon;
  String membershipIcon;

  UserLevel({this.levelIcon, this.constellationIcon, this.membershipIcon});

  UserLevel.fromJson(Map<String, dynamic> json) {
    levelIcon = json['level_icon'];
    constellationIcon = json['constellation_icon'];
    membershipIcon = json['membership_icon'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['level_icon'] = this.levelIcon;
    data['constellation_icon'] = this.constellationIcon;
    data['membership_icon'] = this.membershipIcon;
    return data;
  }
}

class Tags {
  String type;
  String name;
  int tagId;
  int id;

  Tags({this.type, this.name, this.tagId, this.id});

  Tags.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    name = json['name'];
    tagId = json['tag_id'];
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['type'] = this.type;
    data['name'] = this.name;
    data['tag_id'] = this.tagId;
    data['id'] = this.id;
    return data;
  }
}
