/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/ProjectDetailsItem.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

class ProjectDetailsItemView extends StatelessWidget {
  Groups listData;
  List<Widget> listAttrs = [];

  ProjectDetailsItemView(this.listData) {
    init();
  }

  init() {
    for (var item in listData.attrs) {
      listAttrs.add(getAttrItem(item));
    }
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Container(
            padding: EdgeInsets.only(left: 15.0),
            margin: EdgeInsets.only(bottom: 16.0),
            alignment: Alignment.centerLeft,
            height: 40,
            decoration: BoxDecoration(
                image: DecorationImage(
                    image: AssetImage("assets/bg_project_detail_item.png"),
                    fit: BoxFit.cover)),
            child: baseText(listData.name, 15, Colors.black, bold: true)),
        Column(
          children: listAttrs,
        ),
        SizedBox(
          height: 5,
        )
      ],
    );
  }

  getAttrItem(Attrs attrs) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Container(
            margin: EdgeInsets.only(right: 25.0, left: 15, bottom: 25),
            width: 78,
            child: baseText(attrs.attrName.empty() ? "暂无" : attrs.attrName, 13,
                Color(0xFF999999),
                textAlign: TextAlign.start,
                maxLines: 2,
                overflow: TextOverflow.ellipsis)),
        Expanded(
          child: Container(
              margin: EdgeInsets.only(right: 15, bottom: 25),
              child: baseText(attrs.attrValue.empty() ? "暂无" : attrs.attrValue,
                  14, Color(0xFF282828),
                  textAlign: TextAlign.start,
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis)),
        ),
      ],
    );
  }
}
