/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/ClueModel/page/ProjectDetails/ProjectDetailsItemView.dart';
import 'package:gm_flutter/ClueModel/page/ProjectDetails/ProjectDetailsModel.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

import '../../../main.mark.dart';
import '../../server/entity/ProjectDetailsItem.dart';

class ProjectDetailsPage extends StatefulWidget {
  int _planId;

  ProjectDetailsPage(Map<String, dynamic> params) {
    this._planId = params["planId"];
  }

  @override
  State<StatefulWidget> createState() => _ProjectDetailsState();
}

class _ProjectDetailsState extends BaseState<ProjectDetailsPage> {
  ProjectDetailsModel _model;

  @override
  void initState() {
    super.initState();
    _model = new ProjectDetailsModel();
    _model.init(widget._planId);
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      appBar: baseAppBar(
          title: "项目说明",
          centerTitle: true,
          backClick: () {
            if (RouterCenterImpl().findMainRouter().isWithNative()) {
              FlutterBoost.singleton.closeCurrent();
            } else {
              Navigator.of(context).pop();
            }
          }),
      body: Container(
        child: getBody(),
      ),
    );
  }

  getBody() {
    return StreamBuilder(
      stream: _model.liveData.stream,
      initialData: _model.liveData.data ?? null,
      builder: (c, data) {
        if (_model.liveData.data == null) {
//          return loadingItem();
          return Container();
        }
        ProjectDetailsItem item = data.data;
        if (item == null ||
            item.data == null ||
            item.data.groups == null ||
            item.data.groups.isEmpty) {
          return emptyItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height);
        }
        if (item.error != 0) {
          return errorItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height, () {
            _model.init(widget._planId);
          });
        }
        return ListView.builder(
            itemCount: item.data.groups.length,
            itemBuilder: (BuildContext context, int position) {
              return ProjectDetailsItemView(item.data.groups[position]);
            });
      },
    );
  }
}
