/*
 * @author lsy
 * @date   2020/7/1
 **/
class PlanFeedBean {
  int error;
  String message;
  String extra;
  String errorExtra;
  UserType userType;
  Data data;

  PlanFeedBean(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  PlanFeedBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();
  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  List<Plans> plans;

  Data({this.plans});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['plans'] != null) {
      plans = new List<Plans>();
      json['plans'].forEach((v) {
        plans.add(new Plans.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.plans != null) {
      data['plans'] = this.plans.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Plans {
  String cardType;
  String name;
  String positiveRate;
  String salesCount;
  List<BaseAttrs> baseAttrs;
  String minPrice;
  String maxPrice;
  String projectImage;

  Plans(
      {this.cardType,
      this.name,
      this.positiveRate,
      this.salesCount,
      this.baseAttrs,
      this.minPrice,
      this.maxPrice,
      this.projectImage});

  Plans.fromJson(Map<String, dynamic> json) {
    cardType = json['card_type'];
    name = json['name'];
    positiveRate = json['positive_rate'];
    salesCount = json['sales_count'];
    if (json['base_attrs'] != null) {
      baseAttrs = new List<BaseAttrs>();
      json['base_attrs'].forEach((v) {
        baseAttrs.add(new BaseAttrs.fromJson(v));
      });
    }
    minPrice = json['min_price'];
    maxPrice = json['max_price'];
    projectImage = json['project_image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['card_type'] = this.cardType;
    data['name'] = this.name;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    if (this.baseAttrs != null) {
      data['base_attrs'] = this.baseAttrs.map((v) => v.toJson()).toList();
    }
    data['min_price'] = this.minPrice;
    data['max_price'] = this.maxPrice;
    data['project_image'] = this.projectImage;
    return data;
  }
}

class BaseAttrs {
  int attrId;
  String attrName;
  String attrValue;

  BaseAttrs({this.attrId, this.attrName, this.attrValue});

  BaseAttrs.fromJson(Map<String, dynamic> json) {
    attrId = json['attr_id'];
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_id'] = this.attrId;
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}
