/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'dart:math';

import 'package:flutter/cupertino.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneItem.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/util/PosUtil.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'LevelOneBar.dart';

class LevelOnePage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => LevelOneState();
}

class LevelOneState extends BaseState<LevelOnePage>
    with TickerProviderStateMixin {
  LevelOneModel _model = new LevelOneModel();
  RefreshController _refreshController = RefreshController();
  PageController pageController = new PageController();
  GlobalKey keyTop = new GlobalKey();
  GlobalKey key1 = new GlobalKey();
  double screenWidth;
  List<Widget> oneList = new List();
  int lastPageIndex = 0;

  @override
  void initState() {
    super.initState();
    Future.delayed(Duration(seconds: 3), () {
      _model.loadingLive.notifyView(false);
      _model.refreshView(true);
    });
    pageController.addListener(() {
      if (screenWidth != null) {
        _model.topScrollLive.notifyView(
            pageController.offset / screenWidth * (screenWidth / 4));
      }
    });
    oneList.add(head());
    oneList.add(good());
    oneList.add(rect());
    oneList.add(explain());
    oneList.add(Container(
      height: 5,
      color: Color(0xffF7F6FA),
    ));
    oneList.add(feed());
    oneList.add(pages());
  }

  void _onScroll(double offset) {
    if (offset < 10) {
      _model.appBarLive.notifyView(0.0);
    } else if (offset < 500) {
      var topPos = PosUtil.findPos(keyTop);
      if (topPos != null && topPos.dy < 0) {
        double dy = -topPos.dy;
        if (dy < 20) {
          dy = 0;
        }
        double alpha = dy / 112;
        if (alpha < 0) {
          alpha = 0;
        } else if (alpha > 1) {
          alpha = 1;
        }
        _model.appBarLive.notifyView(alpha);
      }
    }
    if (offset > 100) {
      var key1Pos = PosUtil.findPos(key1);
      if (key1Pos != null) {
        if (key1Pos.dy < 86) {
          _model.showTab.notifyView(true);
        } else {
          _model.showTab.notifyView(false);
        }
      }
    }
  }

  @override
  void dispose() {
    _model.dispose();
    pageController.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
        backgroundColor: Colors.white,
        body: SafeArea(
            top: false,
            child: StreamBuilder<bool>(
              stream: _model.loadingLive.stream,
              initialData: true,
              builder: (c, data) {
                if (data.data) {
                  return loadingItem();
                } else {
                  return home();
                }
              },
            )));
  }

  Widget home() {
    return Column(
      children: <Widget>[
        Expanded(
          child: Stack(
            children: <Widget>[
              MediaQuery.removePadding(
                  removeTop: true,
                  context: context,
                  child: NotificationListener(
                    onNotification: (scrollNotification) {
                      if (scrollNotification is ScrollUpdateNotification &&
                          scrollNotification.metrics.axisDirection.index == 2) {
                        _onScroll(scrollNotification.metrics.pixels);
                      }
                      return false;
                    },
                    child: baseRefreshView(
                      _refreshController,
                      () {
                        //TODO
//                            _refreshController.refreshCompleted();
                      },
                      null,
                      null,
                      customScrollView: CustomScrollView(
                        slivers: <Widget>[
                          SliverList(
                            delegate: SliverChildBuilderDelegate(
                              (BuildContext context, int index) {
                                return oneList[index];
                              },
                              childCount: oneList.length,
                            ),
                          ),
                        ],
                      ),
                      pullUp: true,
                      onLoading: () {
                        _model.loadMore();
                      },
                    ),
                  )),
              StreamBuilder<double>(
                stream: _model.appBarLive.stream,
                initialData: _model.appBarLive.data ?? 0.0,
                builder: (c, data) {
                  return Opacity(
                    opacity: data.data,
                    child: Container(
                      height: 86,
                      decoration: BoxDecoration(color: Colors.white),
                      child: Center(
                        child: Padding(
                          padding: EdgeInsets.only(top: 20),
                          child: Text('文案'),
                        ),
                      ),
                    ),
                  );
                },
              ),
              Positioned(
                top: 86,
                child: StreamBuilder<bool>(
                  stream: _model.showTab.stream,
                  initialData: _model.showTab.data ?? false,
                  builder: (c, data) {
                    return Visibility(
                        visible: data.data,
                        child: Container(
                          width: MediaQuery.of(context).size.width,
                          color: Colors.white,
                          child: MessageBarView(
                            topIndexLive: _model.topIndexLive,
                            topScrollLive: _model.topScrollLive,
                            pageController: pageController,
                          ),
                        ));
                  },
                ),
              ),
              baseSliverBack(() {
                Navigator.of(context).pop();
              })
            ],
          ),
        ),
        Container(
          height: 0.5,
          width: double.maxFinite,
          color: Color(0xffE5E5E5),
        ),
        Container(
          width: double.maxFinite,
          height: 55,
          child: Row(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(left: 18),
                width: 30,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    Container(
                      width: 22,
                      height: 22,
                      child: Image.asset("assets/vs_black.png"),
                    ),
                    Container(
                      margin: EdgeInsets.only(top: 3),
                      child: baseText("去比较", 10, Color(0xff282828)),
                    )
                  ],
                ),
              ),
              GestureDetector(
                  behavior: HitTestBehavior.opaque,
                  onTap: () {},
                  child: Container(
                    margin: EdgeInsets.only(left: 15),
                    width: 135,
                    height: 40,
                    decoration: BoxDecoration(
                        color: Color(0xff51CDC7),
                        borderRadius: BorderRadius.circular(20)),
                    alignment: Alignment.center,
                    child: baseText("咨询", 14, Colors.white, bold: true),
                  )),
              GestureDetector(
                  behavior: HitTestBehavior.opaque,
                  onTap: () {},
                  child: Container(
                    margin: EdgeInsets.only(left: 15),
                    width: 135,
                    height: 40,
                    decoration: BoxDecoration(
                        color: Color(0xffF96079),
                        borderRadius: BorderRadius.circular(20)),
                    alignment: Alignment.center,
                    child: baseText("获取底价", 14, Colors.white, bold: true),
                  )),
              Expanded(
                child: Container(),
              )
            ],
          ),
        )
      ],
    );
  }

  Widget head() {
    return Container(
      key: keyTop,
      width: double.maxFinite,
      height: 200,
      alignment: Alignment.topLeft,
      decoration: BoxDecoration(
          image: DecorationImage(
              fit: BoxFit.cover,
              image: NetworkImage(
                  "https://pic.igengmei.com/2018/09/11/1513/b7e825a4e4c1-w"))),
//      child: ,
    );
  }

  Widget good() {
    return Container(
      width: double.maxFinite,
      height: 54,
      margin: EdgeInsets.only(top: 18, bottom: 12),
      child: Stack(
        children: <Widget>[
          Positioned(
            top: 6,
            left: 15,
            child: baseText("TODO", 18, Color(0xff282828), bold: true),
          ),
          Positioned(
            bottom: 8,
            left: 15,
            child: baseText("TODO", 12, Color(0xff999999)),
          ),
          Positioned(
            right: 0,
            child: Container(
              width: 100,
              height: 54,
              decoration: BoxDecoration(
                  gradient: LinearGradient(colors: [
                Color(0xFFFFF0F5),
                Color(0xffFFF8FA),
                Color(0xFFFFFFFF)
              ], begin: FractionalOffset(1, 0), end: FractionalOffset(0, 1))),
            ),
          ),
          Positioned(
            right: 15,
            top: 6,
            child: Row(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.end,
              children: <Widget>[
                baseText("好评率", 11, Color(0xff282828)),
                Container(
                  margin: EdgeInsets.only(left: 4),
                  child: baseText("99", 20, Color(0xffFF5963)),
                ),
                baseText("%", 11, Color(0xffFF5963)),
              ],
            ),
          ),
          Positioned(
            right: 15,
            bottom: 8,
            child: baseText("销量110", 11, Color(0xff666666)),
          )
        ],
      ),
    );
  }

  Widget rect() {
    return StreamBuilder<List<String>>(
      stream: _model.rectLive.stream,
      initialData: ["w", "w", "q", "w"],
      builder: (c, data) {
        List<Widget> list = List();
        for (int i = 0; i < data.data.length; i += 2) {
          list.add(Expanded(
            child: Container(
              alignment: Alignment.center,
              child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  baseText(data.data[i], 14, Color(0xff282828), bold: true),
                  baseText(data.data[i + 1], 11, Color(0xff999999)),
                ],
              ),
            ),
          ));
          if (i < data.data.length - 2) {
            list.add(Container(
              width: 0.5,
              height: 18,
              color: Color(0xFFE5E5E5),
            ));
          }
        }
        return Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(4),
            color: Color(0xffF9F8FB),
          ),
          width: double.maxFinite,
          height: 62,
          margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: list,
          ),
        );
      },
    );
  }

  Widget explain() {
    return StreamBuilder<List<String>>(
      stream: _model.explainLive.stream,
      initialData: ["www", "www", "www", "??"],
      builder: (c, data) {
        List<Widget> list = [];
        list.add(Container(
          height: 31,
          child: Row(
            children: <Widget>[
              baseText("项目说明", 15, Color(0xff282828)),
              Expanded(
                child: Container(),
              ),
              GestureDetector(
                onTap: () {
                  //TODO
                },
                behavior: HitTestBehavior.opaque,
                child: baseText("了解更多", 12, Color(0xff3FB5AF)),
              )
            ],
          ),
        ));
        for (int i = 0; i < data.data.length; i += 2) {
          list.add(Container(
            height: 28,
            child: Row(
              children: <Widget>[
                baseText(data.data[i], 13, Color(0xff999999)),
                Container(
                  margin: EdgeInsets.only(left: 12),
                  child: baseText(data.data[i + 1], 13, Color(0xff666666)),
                )
              ],
            ),
          ));
        }
        return Container(
          margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: list,
          ),
        );
      },
    );
  }

  Widget feed() {
    return Container(
        key: key1,
        child: MessageBarView(
          topIndexLive: _model.topIndexLive,
          topScrollLive: _model.topScrollLive,
          pageController: pageController,
        ));
  }

  Widget pages() {
    return StreamBuilder<Pair<int, List<Cards>>>(
      stream: _model.cardsLive.stream,
      initialData: _model.cardsLive.data ?? Pair(LOADING, null),
      builder: (c, data) {
        double height = MediaQuery.of(context).size.height - 86 - 55.5 - 49;
        if (_model.data[_model.currentIndex] != null &&
            _model.data[_model.currentIndex].length > 0) {
          height = max(
              _model.data[_model.currentIndex].length *
                  _model.pageHeightList[_model.currentIndex] *
                  1.0,
              height);
        }
        return Container(
          width: double.maxFinite,
          height: height,
          child: PageView.builder(
            itemBuilder: (c, pageIndex) {
              if (data.data.first == FAIL) {
                return errorItem(MediaQuery.of(context).size.width, height, () {
                  _model.refreshView(true);
                });
              }
              if (data.data.first == LOADING ||
                  _model.data[pageIndex] == null) {
                return loadingItem();
              }
              if (data.data.second.length == 0) {
                if (_model.pageList[pageIndex] == 1) {
                  return emptyItem(MediaQuery.of(context).size.width, height);
                } else {
                  _refreshController.loadNoData();
                }
              } else {
                _refreshController.loadComplete();
              }
              return ListView.builder(
                physics: NeverScrollableScrollPhysics(),
                itemBuilder: (c, index) {
                  return LevelOneItem(_model.data[pageIndex][index]);
                },
                itemCount: _model.data[pageIndex].length,
              );
            },
            allowImplicitScrolling: false,
            dragStartBehavior: DragStartBehavior.down,
            controller: pageController,
            itemCount: 4,
            onPageChanged: (index) {
              _refreshController.resetNoData();
              setState(() {
              });
              _model.topIndexLive.notifyView(index);
              _model.selectPage(index);
            },
          ),
        );
      },
    );
  }
}
