/*
 * @author lsy
 * @date   2019-10-08
 **/

import 'package:shared_preferences/shared_preferences.dart';

import 'MemoryCache.dart';
import 'ShareCache.dart';

const MEMORY_CACHE = "MEMORY_CACHE";
const SHARE_CACHE = "SHARE_CACHE";

SharedPreferences sharedPreferences;

class CacheManager {
  MemoryCache memoryCache;
  ShareCache shareCache;

  static CacheManager _instance = CacheManager._();

  CacheManager._() {
    memoryCache = new MemoryCache();
    shareCache = new ShareCache();
  }

  static CacheManager getInstance() {
    return _instance;
  }

  ICache get(String whichCache) {
    if (whichCache == MEMORY_CACHE) {
      return memoryCache;
    } else if (whichCache == SHARE_CACHE) {
      return shareCache;
    }
  }
}

class ICache {
  dynamic get(String key) {}

  void save(String key, dynamic value) {}

  void clearAll(){}
}
