/*
 * @author lsy
 * @date   2020/5/14
 **/
import 'package:dio_cookie_manager/dio_cookie_manager.dart';
import 'package:cookie_jar/cookie_jar.dart';

class DioCookieManager {
  static DioCookieManager _cookieManager;
  DefaultCookieJar cookieJar;
  CookieManager cookieManager;

  DioCookieManager._() {
    cookieJar = new DefaultCookieJar();
    cookieManager = new CookieManager(cookieJar);
  }

  static DioCookieManager getInstance() {
    if (_cookieManager == null) {
      _cookieManager = new DioCookieManager._();
    }
    return _cookieManager;
  }

  CookieManager getCookieManager() {
    return cookieManager;
  }

  void clearCookie() {
    cookieJar.deleteAll();
  }
}
