import 'dart:convert';
import 'dart:io';
import 'package:dio/adapter.dart';
import 'package:dio/dio.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';

import 'Api.dart';
import 'DioCookieManager.dart';
import 'DioInterceptor.dart';

const NET_COOKIE = "NET_COOKIE";

class DioUtil {
  static final DioUtil _instance = DioUtil._init();
  static Dio _dio;
  static BaseOptions _options = getDefOptions();

  static Map<String, dynamic> addHeadMap;

  /// 是否是debug模式.
  static bool _isDebug = isDebug;

  static DioUtil getInstance() {
    return _instance;
  }

  factory DioUtil() {
    return _instance;
  }

  static var interceptor = InterceptorsWrapper();

  DioUtil._init() {
    _dio = new Dio(_options);
    _dio.interceptors.add(DioInterceptorManager.getInstance().getIntercept());
    _dio.interceptors.add(DioCookieManager.getInstance().getCookieManager());
  }

  void clearCookie() {
    DioCookieManager.getInstance().clearCookie();
  }

  void setProxy(String proxy) {
    _dio = new Dio(_options);
    _dio.interceptors.add(DioInterceptorManager.getInstance().getIntercept());
    _dio.interceptors.add(DioCookieManager.getInstance().getCookieManager());
    (_dio.httpClientAdapter as DefaultHttpClientAdapter).onHttpClientCreate =
        (client) {
      client.findProxy = (url) {
        return 'PROXY $proxy:8888';
      };
    };
  }

  Dio getDio() {
    return _dio;
  }

  static BaseOptions getDefOptions() {
    BaseOptions options = BaseOptions();
    options.connectTimeout = 10 * 1000;
    options.receiveTimeout = 20 * 1000;
    options.responseType = ResponseType.plain;
    Map<String, dynamic> headers = Map<String, dynamic>();
    headers['Accept'] = 'application/json';
    headers['version'] = '1.0.0';
    options.headers = headers;
    options.baseUrl = Api.getInstance().getBaseUrl() + "/";
    return options;
  }
}
