/*
 * @Author: zx 
 * @Date: 2020-06-30 17:43:13 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-02 13:50:15
 */
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

class PlanCompareDetailModel extends BaseModel {
  LiveData<Pair<int, List<Groups>>> detailLive = LiveData();
  LiveData<List<PlansInfoDetail>> headerLive = LiveData();
  LiveData<int> stateLive = LiveData();

  RxDispose rxDispose = RxDispose();

  void init(String planIds) {
    ClueApiImpl.getInstance()
        .getPlanCompareDetail(DioUtil.getInstance().getDio(), planIds)
        .listen((event) {
          if (event.error == 0) {
            stateLive.notifyView(ENDLOADING);
            if (event.data.plansInfo != null &&
                event.data.plansInfo.length > 1) {
              headerLive.notifyView(event.data.plansInfo);
            }
            if (event.data.groups == null || event.data.groups.isEmpty) {
              detailLive.notifyView(Pair(EMPTY, null));
            } else {
              detailLive.notifyView(Pair(ENDLOADING, event.data.groups));
            }
          } else {
            stateLive.notifyView(FAIL);
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          stateLive.notifyView(FAIL);
          PrintUtil.printBug(err);
        });
  }

  @override
  void dispose() {
    stateLive.dispost();
    detailLive.dispost();
    headerLive.dispost();
  }
}
