/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanOverViewBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class LevelOneModel extends BaseModel {
  LiveData<double> appBarLive = LiveData();
  LiveData<bool> showTab = LiveData();
  LiveData<int> topIndexLive = new LiveData();
  LiveData<double> topScrollLive = new LiveData();
  LiveData<int> stateLive = LiveData();
  LiveData<double> textLive = LiveData();

  RxDispose rxDispose = RxDispose();
  LiveData<Pair<int, List<Cards>>> cardsLive = LiveData();

  Map<int, List<Cards>> data = new Map();
  List list = ["plan", "hospital", "doctor", "diary"];
  List<Tabs> tabsList = [];
  List pageList = [1, 1, 1, 1];
  List pageHeightList = [118, 149, 118, 118];
  int plan_id = 0;
  PlanOverData planoverItem;

  void init(VoidCallback callback) {
    ClueApiImpl.getInstance()
        .getPlanOverView(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            planoverItem=event.data;
            tabsList = event.data.tabs;
            stateLive.notifyView(ENDLOADING);
            callback();
          } else {
            NativeToast.showNativeToast(event.message);
            stateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }


  int currentIndex = 0;

  @override
  void dispose() {
    showTab.dispost();
    cardsLive.dispost();
    appBarLive.dispost();
    topIndexLive.dispost();
    topScrollLive.dispost();
    stateLive.dispost();
    textLive.dispost();
  }

  void selectTab(int index) {

  }
}
