/*
 * @Author: zx 
 * @Date: 2020-06-30 17:43:13 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-02 13:50:15
 */
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

class PlanCompareDetailModel extends BaseModel {
  LiveData<Pair<int, List<Groups>>> detailLive = LiveData();
  LiveData<Pair<int, List<PlansInfo>>> headerLive = LiveData();
  LiveData<int> stateLive = LiveData();

  RxDispose rxDispose = RxDispose();

  void init(List<int> planIds) {
    ClueApiImpl.getInstance()
        .getPlanCompareDetail(DioUtil.getInstance().getDio(), planIds)
        .listen((event) {
          if (event.error == 0) {
            stateLive.notifyView(ENDLOADING);
            if (event.data.plansInfo == null || event.data.groups.isEmpty) {
              headerLive.notifyView(Pair(ENDLOADING, []));
              detailLive.notifyView(Pair(ENDLOADING, []));
            } else {
              detailLive.notifyView(Pair(ENDLOADING, event.data.groups));
              headerLive.notifyView(Pair(ENDLOADING, event.data.plansInfo));
            }
          } else {
            stateLive.notifyView(FAIL);
            NativeToast.showNativeToast(event.message);
            headerLive.notifyView(Pair(FAIL, null));
            detailLive.notifyView(Pair(FAIL, null));
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          stateLive.notifyView(FAIL);
          headerLive.notifyView(Pair(FAIL, null));
          detailLive.notifyView(Pair(FAIL, null));
          NativeToast.showNativeToast(err.message);
        });
  }

  @override
  void dispose() {
    stateLive.dispost();
    detailLive.dispost();
    headerLive.dispost();
  }
}
