/*
 * @author lsy
 * @date   2019-10-08
 **/


import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:shared_preferences/shared_preferences.dart';

import 'CacheManager.dart';

class ShareCache implements ICache {
  @override
  get(String key) {
    return sharedPreferences.get(key);
  }

  @override
  void save(String key, value) {
    if (value is String) {
      sharedPreferences.setString(key, value).whenComplete(() {
        if (isDebug) {
          print("save String ${value} success");
        }
      });
    } else if (value is bool) {
      sharedPreferences.setBool(key, value).whenComplete(() {
        if (isDebug) {
          print("save bool ${value} success");
        }
      });
    } else if (value is double) {
      sharedPreferences.setDouble(key, value).whenComplete(() {
        if (isDebug) {
          print("save double ${value} success");
        }
      });
    } else if (value is int) {
      sharedPreferences.setInt(key, value).whenComplete(() {
        if (isDebug) {
          print("save int ${value} success");
        }
      });
    } else if (value is List<String>) {
      sharedPreferences.setStringList(key, value).whenComplete(() {
        if (isDebug) {
          print("save StringList ${value} success");
        }
      });
    } else {
      if (isDebug) {
        throw Exception("save error type");
      }
    }
  }

  @override
  void clearAll() {
    sharedPreferences.clear().whenComplete(() {});
  }
}
