import 'dart:async';

import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/Annotations/anno/RouterCenter.dart';
import 'package:flutter_common/commonModel/util/WindowUtil.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:gm_flutter/ClueModel/page/PlanCompareDetail/PlanCompareDetailPage.dart';
import 'DemoPage.dart';
import 'DemoPage1.dart';
import 'commonModel/base/BaseComponent.dart';
import 'commonModel/base/BaseUtil.dart';
import 'commonModel/cache/CacheManager.dart';
import 'commonModel/nav/NavigationService.dart';
import 'main.mark.dart';

NavigationService navigationService;

void main() {
  navigationService = NavigationService();
  WidgetsFlutterBinding.ensureInitialized();
  FlutterError.onError = (FlutterErrorDetails details) async {
    if (isDebug) {
      FlutterError.dumpErrorToConsole(details);
      Zone.root.handleUncaughtError(details.exception, details.stack);
      Zone.current.handleUncaughtError(details.exception, details.stack);
    } else {
      Zone.current.handleUncaughtError(details.exception, details.stack);
    }
  };
  runZonedGuarded(() {
    WidgetsFlutterBinding.ensureInitialized();
    runApp(
      MyAppWidget(),
    );
    SharedPreferences.getInstance().then((value) {
      sharedPreferences = value;
    });
    RouterCenterImpl().findMainRouter().init();
  }, (Object error, StackTrace stack) {
    //TODO
    print("lsy EEEEEE ${error.toString()}   ${stack.toString()}");
  });
}

@RouterCenter()
class MyAppWidget extends StatefulWidget {
  @override
  State<StatefulWidget> createState() {
    return MyApp();
  }
}

class MyApp extends State<MyAppWidget> {
  @override
  void initState() {
    super.initState();
    FlutterBoost.singleton.registerPageBuilders({
      'demoPage': (pageName, params, _) {
        return DemoPage();
      },
      'demoPage1': (pageName, params, _) {
        return DemoPage1();
      },
    });
    FlutterBoost.singleton
        .addBoostContainerLifeCycleObserver((state, settings) {
      print("LSY ${state}");
    });
//    FlutterBoost.singleton.addBoostNavigatorObserver(TestBoostNavigatorObserver());
  }

  @override
  Widget build(BuildContext context) {
    WindowUtil.setBarStatus(true);
    return MaterialApp(
        theme: ThemeData(
            primaryColor: Colors.white,
            cursorColor: Color(0xff20BDBB),
            highlightColor:Colors.transparent,
            splashColor:Colors.transparent,
            canvasColor: Colors.white),

        builder: FlutterBoost.init(postPush: _onRoutePushed),
        home: isDebug
            ? RouterCenterImpl().findMainRouter().getTestPage()
            : Container(
          color: Colors.white,
          child: Center(
            child: loadingItem(),
          ),
        ));
  }

  void _onRoutePushed(
    String pageName,
    String uniqueId,
    Map<String, dynamic> params,
    Route<dynamic> route,
    Future<dynamic> _,
  ) {}
}
