/*
 * @author lsy
 * @date   2020/7/3
 **/
class PlanOverViewBean {
  int error;
  String message;
  Null extra;
  Null errorExtra;
  UserType userType;
  PlanOverData data;

  PlanOverViewBean(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  PlanOverViewBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new PlanOverData.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class PlanOverData {
  Banner banner;
  String name;
  String positiveRate;
  String salesCount;
  String planDescription;
  String guidePrice;
  List<OverviewAttrs> overviewAttrs;
  List<ExplanationAttrs> explanationAttrs;
  List<Tabs> tabs;

  PlanOverData(
      {this.banner,
      this.name,
      this.positiveRate,
      this.salesCount,
      this.planDescription,
      this.guidePrice,
      this.overviewAttrs,
      this.explanationAttrs,
      this.tabs});

  PlanOverData.fromJson(Map<String, dynamic> json) {
    banner =
        json['banner'] != null ? new Banner.fromJson(json['banner']) : null;
    name = json['name'];
    positiveRate = json['positive_rate'];
    salesCount = json['sales_count'];
    planDescription = json['plan_description'];
    guidePrice = json['guide_price'];
    if (json['overview_attrs'] != null) {
      overviewAttrs = new List<OverviewAttrs>();
      json['overview_attrs'].forEach((v) {
        overviewAttrs.add(new OverviewAttrs.fromJson(v));
      });
    }
    if (json['explanation_attrs'] != null) {
      explanationAttrs = new List<ExplanationAttrs>();
      json['explanation_attrs'].forEach((v) {
        explanationAttrs.add(new ExplanationAttrs.fromJson(v));
      });
    }
    if (json['tabs'] != null) {
      tabs = new List<Tabs>();
      json['tabs'].forEach((v) {
        tabs.add(new Tabs.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.banner != null) {
      data['banner'] = this.banner.toJson();
    }
    data['name'] = this.name;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    data['plan_description'] = this.planDescription;
    data['guide_price'] = this.guidePrice;
    if (this.overviewAttrs != null) {
      data['overview_attrs'] =
          this.overviewAttrs.map((v) => v.toJson()).toList();
    }
    if (this.explanationAttrs != null) {
      data['explanation_attrs'] =
          this.explanationAttrs.map((v) => v.toJson()).toList();
    }
    if (this.tabs != null) {
      data['tabs'] = this.tabs.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Banner {
  String type;
  String imageUrl;
  String videoUrl;

  Banner({this.type, this.imageUrl, this.videoUrl});

  Banner.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    imageUrl = json['image_url'];
    videoUrl = json['video_url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['type'] = this.type;
    data['image_url'] = this.imageUrl;
    data['video_url'] = this.videoUrl;
    return data;
  }
}

class OverviewAttrs {
  int attrId;
  String attrName;
  String attrValue;

  OverviewAttrs({this.attrId, this.attrName, this.attrValue});

  OverviewAttrs.fromJson(Map<String, dynamic> json) {
    attrId = json['attr_id'];
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_id'] = this.attrId;
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}

class Tabs {
  String tabType;
  String name;

  Tabs({this.tabType, this.name});

  Tabs.fromJson(Map<String, dynamic> json) {
    tabType = json['tab_type'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tab_type'] = this.tabType;
    data['name'] = this.name;
    return data;
  }
}

class ExplanationAttrs {
  int attrId;
  String attrName;
  String attrValue;

  ExplanationAttrs({this.attrId, this.attrName, this.attrValue});

  ExplanationAttrs.fromJson(Map<String, dynamic> json) {
    attrId = json['attr_id'];
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_id'] = this.attrId;
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}
