/*
 * @author lsy
 * @date   2020/6/29
 **/
class LevelPreview {
  Banner banner;
  String name;
  String positiveRate;
  String salesCount;
  String planDescription;
  List<OverviewAttrs> overviewAttrs;
  List<ExplanationAttrs> explanationAttrs;
  List<Tabs> tabs;

  LevelPreview(
      {this.banner,
        this.name,
        this.positiveRate,
        this.salesCount,
        this.planDescription,
        this.overviewAttrs,
        this.explanationAttrs,
        this.tabs});

  LevelPreview.fromJson(Map<String, dynamic> json) {
    banner =
    json['banner'] != null ? new Banner.fromJson(json['banner']) : null;
    name = json['name'];
    positiveRate = json['positive_rate'];
    salesCount = json['sales_count'];
    planDescription = json['plan_description'];
    if (json['overview_attrs'] != null) {
      overviewAttrs = new List<OverviewAttrs>();
      json['overview_attrs'].forEach((v) {
        overviewAttrs.add(new OverviewAttrs.fromJson(v));
      });
    }
    if (json['explanation_attrs'] != null) {
      explanationAttrs = new List<ExplanationAttrs>();
      json['explanation_attrs'].forEach((v) {
        explanationAttrs.add(new ExplanationAttrs.fromJson(v));
      });
    }
    if (json['tabs'] != null) {
      tabs = new List<Tabs>();
      json['tabs'].forEach((v) {
        tabs.add(new Tabs.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.banner != null) {
      data['banner'] = this.banner.toJson();
    }
    data['name'] = this.name;
    data['positive_rate'] = this.positiveRate;
    data['sales_count'] = this.salesCount;
    data['plan_description'] = this.planDescription;
    if (this.overviewAttrs != null) {
      data['overview_attrs'] =
          this.overviewAttrs.map((v) => v.toJson()).toList();
    }
    if (this.explanationAttrs != null) {
      data['explanation_attrs'] =
          this.explanationAttrs.map((v) => v.toJson()).toList();
    }
    if (this.tabs != null) {
      data['tabs'] = this.tabs.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Banner {
  String type;
  String url;

  Banner({this.type, this.url});

  Banner.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    url = json['url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['type'] = this.type;
    data['url'] = this.url;
    return data;
  }
}

class OverviewAttrs {
  int attrId;
  String attrName;
  String attrValue;

  OverviewAttrs({this.attrId, this.attrName, this.attrValue});

  OverviewAttrs.fromJson(Map<String, dynamic> json) {
    attrId = json['attr_id'];
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_id'] = this.attrId;
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}

class Tabs {
  String tabType;
  String name;

  Tabs({this.tabType, this.name});

  Tabs.fromJson(Map<String, dynamic> json) {
    tabType = json['tab_type'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tab_type'] = this.tabType;
    data['name'] = this.name;
    return data;
  }


}

class ExplanationAttrs {
  int attrId;
  String attrName;
  String attrValue;

  ExplanationAttrs({this.attrId, this.attrName, this.attrValue});

  ExplanationAttrs.fromJson(Map<String, dynamic> json) {
    attrId = json['attr_id'];
    attrName = json['attr_name'];
    attrValue = json['attr_value'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['attr_id'] = this.attrId;
    data['attr_name'] = this.attrName;
    data['attr_value'] = this.attrValue;
    return data;
  }
}




