/*
 * @author lsy
 * @date   2020/7/8
 **/

import 'package:flutter/material.dart';

class StickyTabBarDelegateWithSize extends SliverPersistentHeaderDelegate {
  final Widget child;
  final double height;

  StickyTabBarDelegateWithSize({@required this.child, this.height});

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    return this.child;
  }

  @override
  double get maxExtent => height ?? 40;

  @override
  double get minExtent => height ?? 40;

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) {
    return true;
  }
}
