/*
 * @Author: zx 
 * @Date: 2020-06-30 17:40:43 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-03 13:47:57
 */
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/PlanCompareDetail/PlanCompareDetailModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';

class PlanCompareDetailPage extends StatefulWidget {
  List<int> _planIds;

  PlanCompareDetailPage(Map<String, dynamic> params) {
    this._planIds = params["planIds"];
  }

  @override
  State<StatefulWidget> createState() => PlanCompareDetailPageState();
}

class PlanCompareDetailPageState extends BaseState<PlanCompareDetailPage> {
  PlanCompareDetailModel _model = new PlanCompareDetailModel();
  double screenWidth;
  List<Widget> viewList = new List();

  @override
  void initState() {
    super.initState();
    _model.init(widget._planIds);
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
        appBar: baseAppBar(
            title: "对比详情",
            centerTitle: true,
            backClick: () {
              Navigator.pop(context);
            }),
        body: Container(
          child: reloadPage(),
        ));
  }

  Widget reloadPage() {
    return StreamBuilder(
      stream: _model.stateLive.stream,
      initialData: _model.stateLive.data ?? LOADING,
      builder: (c, data) {
        if (data.data == FAIL) {
          return errorItem(MediaQuery.of(context).size.width,
              MediaQuery.of(context).size.height, () {
            _model.init(widget._planIds);
          });
        }
        if (data.data == LOADING) {
          return loadingItem();
        }
        return setupHome();
      },
    );
  }

  Widget setupHome() {
    return Column(
      children: <Widget>[
        head(),
        Expanded(
            child: Container(
          child: StreamBuilder<Pair<int, List<Groups>>>(
              stream: _model.detailLive.stream,
              initialData: _model.detailLive.data ?? Pair(LOADING, null),
              builder: (c, data) {
                if (data.data.first == FAIL) {
                  return errorItem(MediaQuery.of(context).size.width,
                      MediaQuery.of(context).size.height, () {
                    _model.init([1, 2]);
                  });
                }
                return ListView.builder(
                  itemBuilder: (BuildContext context, int index) {
                    if (index == data.data.second.length * 2 - 1) {
                      return Container(
                        height: 40,
                        color: Color(0xffF7F6FA),
                      );
                    }
                    if (index % 2 != 0) {
                      return Container(
                        height: 5,
                        color: Color(0xffF7F6FA),
                      );
                    }
                    int newIndex = (index / 2).floor();
                    Groups group = data.data.second[newIndex];
                    Widget widget;
                    if (group.groupType == 'hot') {
                      widget = Container(
                        child: planPopularityView(group),
                        // height: 100,
                        // alignment: Alignment.center,
                        // child: baseText("第一个", 15, Colors.black),
                      );
                    } else if (group.groupType == 'normal_attrs') {
                      widget = Container(
                        child: planNormalEffectiveAttrsView(group),
                      );
                    } else if (group.groupType == 'effective_attrs') {
                      widget = Container(
                        child: planNormalEffectiveAttrsView(group),
                      );
                    } else {
                      widget = planNormalEffectiveAttrsView(group);
                    }
                    return Container(
                      margin: EdgeInsets.only(left: 15, right: 15),
                      child: widget,
                    );
                  },
                  itemCount: data.data.second.length * 2,
                );
              }),
        ))
      ],
    );
  }

  Widget head() {
    return Container(
      // key: keyTop,
      width: screenWidth,
      height: 105,
      alignment: Alignment.topLeft,
      margin: EdgeInsets.only(left: 15, right: 15),
      child: Row(children: <Widget>[
        // 根据 flex系数，分配剩余空间
        Expanded(flex: 1, child: headItem(0)),
        Expanded(flex: 1, child: headItem(1))
      ]),
    );
  }

  Widget headItem(int index) {
    return StreamBuilder(
      stream: _model.headerLive.stream,
      initialData: _model.headerLive.data ?? null,
      builder: (c, data) {
        if (data.data == null) {
          return Container();
        }
        PlansInfo planinfo = data.data.second[index];
        return Container(
            child: Stack(children: <Widget>[
          Positioned(
              top: 8,
              left: index == 0 ? 0 : 5.5,
              child: Container(
                height: 75,
                width: (screenWidth - 30 - 11) / 2,
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(7),
                  child: Image.asset('assets/plan_compare_detail_info_bg.png',
                      fit: BoxFit.cover),
                ),
              )),
          Positioned(
            left: 12,
            top: 24,
            child:
                baseText(planinfo.planName, 15, Color(0xff333333), bold: true),
          ),
          Positioned(
            left: 12,
            top: 48,
            child: baseText('￥' + planinfo.minPrice + '-' + planinfo.maxPrice,
                14, Colors.red,
                bold: true),
          ),
        ]));
      },
    );
  }

  Widget titleView(String title) {
    return Container(
      height: 75,
      width: screenWidth,
      margin: EdgeInsets.fromLTRB(0, 30, 0, 20),
      alignment: Alignment.center,
      child: Container(
        width: 90,
        height: 25,
        child: Stack(
          alignment: AlignmentDirectional.center,
          children: <Widget>[
            Positioned(
              bottom: 0,
              child: Container(
                width: 90,
                height: 10,
                child: Image.asset("assets/plan_compare_detail_title_bg.png"),
              ),
            ),
            Positioned(
              top: 0,
              child: baseText(title, 21, Color(0xff282828), bold: true),
            )
          ],
        ),
      ),
    );
  }

  Widget planPopularityView(Groups groups) {
    return Container(
      child: Column(
          mainAxisSize: MainAxisSize.min,
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            titleView(groups.groupName),
            Container(child: planPopularityBodyView(groups)),
            Container()
          ]),
    );
  }

  Widget planPopularityBodyView(Groups groups) {
    return Container(
        height: 170,
        child: Row(children: <Widget>[
          Expanded(flex: 1, child: planPopularityLeftItem(groups.plans[0])),
          Expanded(flex: 1, child: planPopularityRightItem(groups.plans[1]))
        ]));
  }

  Widget planPopularityLeftItem(Plans plan) {
    return Container(
        height: 170,
        child: Stack(children: <Widget>[
          Positioned(
              right: 20,
              top: 0,
              child: baseText(plan.positiveRate, 21, Color(0xff3FB5AF),
                  bold: true)),
          Positioned(
            right: 20,
            top: 24,
            child: baseText('好评率', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
            right: 20,
            top: 46,
            child: FiveStarView(3, 5,
                starAssets: 'assets/plan_compare_detail_green_star_all.png'),
          ),
          Positioned(
            right: 20,
            top: 84,
            child: baseText(plan.salesCount, 21, Color(0xff3FB5AF), bold: true),
          ),
          Positioned(
            right: 20,
            top: 108,
            child: baseText('销量', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
              right: 20,
              bottom: 30,
              child: Container(
                height: 7,
                width: 95,
                child: Stack(children: <Widget>[
                  Positioned(
                    left: 0,
                    top: 0,
                    width: 95,
                    height: 7,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(3.5),
                      child: Container(
                        color: Color(0xffF7F6FA),
                      ),
                    ),
                  ),
                  Positioned(
                    right: 0,
                    top: 0,
                    width: 95 * 0.7,
                    height: 7,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(3.5),
                      child: Container(
                        color: Color(0xff3FB5AF),
                      ),
                    ),
                  ),
                ]),
              )),
        ]));
  }

  Widget planPopularityRightItem(Plans plan) {
    return Container(
        height: 170,
        child: Stack(children: <Widget>[
          Positioned(
              left: 20,
              top: 0,
              child: baseText(plan.positiveRate, 21, Color(0xffF25874),
                  bold: true)),
          Positioned(
            left: 20,
            top: 24,
            child: baseText('好评率', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
              left: 20,
              top: 46,
              child: Container(
                height: 13,
                width: 81,
                child: FiveStarView(
                  3,
                  5,
                  starAssets: 'assets/plan_compare_detail_red_star_all.png',
                ),
              )),
          Positioned(
            left: 20,
            top: 84,
            child: baseText(plan.salesCount, 21, Color(0xffF25874), bold: true),
          ),
          Positioned(
            left: 20,
            top: 108,
            child: baseText('销量', 12, Color(0xff666666), bold: false),
          ),
          Positioned(
              left: 20,
              bottom: 30,
              child: Container(
                height: 7,
                width: 95,
                child: Stack(children: <Widget>[
                  Positioned(
                    left: 0,
                    top: 0,
                    width: 95,
                    height: 7,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(3.5),
                      child: Container(
                        color: Color(0xffF7F6FA),
                      ),
                    ),
                  ),
                  Positioned(
                    left: 0,
                    top: 0,
                    width: 95 * 0.3,
                    height: 7,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(3.5),
                      child: Container(
                        color: Color(0xffF25874),
                      ),
                    ),
                  ),
                ]),
              )),
        ]));
  }

  Widget planNormalEffectiveAttrsView(Groups groups) {
    List<Widget> list = new List();
    list.add(titleView(groups.groupName));
    groups.plans.forEach((element) {
      list.add(planBaseAttrsView(element));
    });
    return Container(
        child: Column(
            mainAxisSize: MainAxisSize.min,
            mainAxisAlignment: MainAxisAlignment.center,
            children: list));
  }

  Widget planBaseAttrsView(Plans plans) {
    return Container(
        height: 56,
        child: Row(children: <Widget>[
          Expanded(flex: 1, child: planBaseAttrsLeftView(plans)),
          Expanded(flex: 1, child: planBaseAttrsRightView(plans))
        ]));
  }

  Widget planBaseAttrsLeftView(Plans plan) {
    return Container(
        height: 56,
        child: Stack(children: <Widget>[
          Positioned(
              right: 20,
              top: 0,
              child: baseText(plan.attrs[0].attrValue, 14, Color(0xff3FB5AF),
                  bold: true)),
          Positioned(
            top: 20,
            right: 20,
            child: baseText(plan.attrs[0].attrName, 12, Color(0xff666666),
                bold: false),
          ),
        ]));
  }

  Widget planBaseAttrsRightView(Plans plan) {
    return Container(
        height: 56,
        child: Stack(children: <Widget>[
          Positioned(
              left: 20,
              top: 0,
              child: baseText(plan.attrs[0].attrValue, 14, Color(0xffF25874),
                  bold: true)),
          Positioned(
            left: 20,
            top: 20,
            child: baseText(plan.attrs[0].attrName, 12, Color(0xff666666),
                bold: false),
          ),
        ]));
  }
}
