/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/services.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

import '../../commonModel/App.dart';

class MainManager {
  MethodChannel flutterChannel;
  EventChannel flutterEvent;
  bool isInit = false;

  MainManager._() {}

  static MainManager _mainManager;

  static MainManager getInstance() {
    if (_mainManager == null) {
      _mainManager = MainManager._();
    }
    return _mainManager;
  }

  startInit() {
    if (isInit) {
      return;
    }
    isInit = true;
    print("LSY STATEINIT METHOD AND CHANNEL ");
    flutterChannel = MethodChannel('gm_method_channel');
    flutterEvent = EventChannel('gm_method_event');
    flutterEvent.receiveBroadcastStream().listen((data) {
      if (data is Map<String, String>) {
        var map = Map<String, String>.from(data);
        innerSetData(map, APP_NAME);
        innerSetData(map, VERSION);
        innerSetData(map, PLATFORM);
        innerSetData(map, DEVICE_ID);
        innerSetData(map, OS_VERSION);
        innerSetData(map, MODEL);
        innerSetData(map, SCREEN);
        innerSetData(map, LAT);
        innerSetData(map, LNG);
        innerSetData(map, CHANNEL);
        innerSetData(map, MANUFACTURER);
        innerSetData(map, UUID);
        innerSetData(map, ANDROID_DEVICE_ID);
        innerSetData(map, CURRENT_CITY_ID);
        innerSetData(map, USER_AGENT);
        innerSetData(map, RELEASE);
        innerSetData(map, IDFA);
        innerSetData(map, IDFV);
        innerSetData(map, IS_WIFI);
        innerSetData(map, HARDWARE_MODEL);
        innerSetData(map, USER_ID);
        innerSetData(map, COOKIE);
        innerSetData(map, BASE_URL);
        DioUtil.setDefOptions(
            baseUrl: map[BASE_URL] + "/",
            cookie: map[COOKIE],
            agent: map[USER_AGENT]);
        DioUtil.getInstance().changeOpt();
      }
    });
  }

  void innerSetData(Map<String, String> map, String str) {
    if (!map[str].empty()) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(str, map[str]);
    }
  }

  void buriedEvent(String name, Map<String, dynamic> map) {
    if (!isInit) {
      return;
    }
    if (flutterChannel != null) {
      flutterChannel.invokeMethod("buried-${name}", map);
    }
  }
}
