/*
 * @author lsy
 * @date   2020/5/22
 **/

import 'dart:async';

class RxDispose {
  List<StreamSubscription> rx;

  RxDispose() {
    rx = List();
  }

  void addDispose(StreamSubscription streamSubscription) {
    rx.add(streamSubscription);
  }

  void dispose() {
    rx.forEach((element) {
      element.cancel();
    });
  }
}

extension StreamSubscriptionExt on StreamSubscription {
  StreamSubscription addToDispose(RxDispose rxDispose) {
    rxDispose.addDispose(this);
    return this;
  }
}
