import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneListModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/ConsultHospitalsBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismModel.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/util/NativeToast.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class MechanismBox implements IBottomPicker {
  VoidCallback dismissCall;
  TextEditingController textController = TextEditingController();
  MechanismModel _model = new MechanismModel();

  RefreshController refreshController = RefreshController();

  Function(String str) refresh;

  int _dateTime = DateTime.now().millisecondsSinceEpoch;

  FocusNode focusNode = new FocusNode();

  @required
  final int plan_id;
  final String pageName;

  MechanismBox(this.plan_id, this.pageName) : super();

  @override
  initState(dismissCall, BuildContext context) {
    this.dismissCall = dismissCall;
    _model.plan_id = plan_id;
    _model.tab_type = "hospital";
    _model.getQuestions(plan_id);
    _model.refreshView(true);
    RouterCenterImpl().findMainRouter().buriedEvent("popup_view", buriedData());
    refresh = (str) {
      _model.stateLive.notifyView(LOADING);
      _model.refreshView(true);
    };
  }

  Map<String, dynamic> buriedData() {
    Map<String, dynamic> params = Map();
    params['page_name'] = this.pageName;
    params['popup_name'] = 'consult';
    return params;
  }

  Widget build(BuildContext context) {
    MediaQueryData mq = MediaQuery.of(context);
    double keyHeight = MediaQuery.of(context).viewInsets.bottom;
    return Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.only(
              topLeft: Radius.circular(10.0), topRight: Radius.circular(10.0)),
          color: Colors.white,
        ),
        width: mq.size.width,
        height: mq.size.height - mq.size.height / 5,
        child: StreamBuilder(
          stream: _model.stateLive.stream,
          initialData: _model.stateLive.data ?? LOADING,
          builder: (c, data) {
            if (data.data == FAIL) {
              return errorItem(MediaQuery.of(context).size.width,
                  MediaQuery.of(context).size.height, () {
                _model.getQuestions(plan_id);
              });
            }
            if (data.data == LOADING) {
              return loadingItem();
            }
            return setupHome(mq, keyHeight, context);
          },
        ));
  }

  @override
  void dispose() {
    focusNode.unfocus();
    textController.dispose();
    refreshController.dispose();
    _model.dispose();
    focusNode.dispose();
  }

  setupHome(mq, keyHeight, BuildContext context) {
    final double bottomPadding = MediaQuery.of(context).padding.bottom;
    var heigth =
        mq.size.height - (mq.size.height / 5) - 146 - bottomPadding - keyHeight;
    return Column(
      mainAxisSize: MainAxisSize.max,
      children: <Widget>[
        title(mq),
        StreamBuilder(
          stream: _model.stateLive.stream,
          initialData: _model.stateLive.data ?? LOADING,
          builder: (c, data) {
            if (data.data == LOADING) {
              return Container(
                width: MediaQuery.of(context).size.width,
                height: heigth,
                child: loadingItem(),
              );
            }
            if (data.data == FAIL) {
              return errorItem(MediaQuery.of(context).size.width, heigth, () {
                _model.refreshView(true);
              });
            }
            if (data.data == EMPTY) {
              return emptyItem(MediaQuery.of(context).size.width, heigth)
                  .gestureDetector(() {
                focusNode.unfocus();
              });
            }
            return mechanismList(mq, heigth);
          },
        ),
        bottomMessage(context, bottomPadding)
      ],
    );
  }

  // 弹窗标题
  Widget title(mq) {
    return GestureDetector(
        onTap: () {
          dismissCall();
        },
        child: Container(
          margin: EdgeInsets.only(left: 15, right: 15),
          width: mq.size.width,
          decoration: BoxDecoration(
              border: Border(
                  bottom: BorderSide(width: .5, color: Color(0xffE5E5E5)))),
          height: 50,
          child: Stack(
            alignment: Alignment.center,
            children: <Widget>[
              Container(
                child: Text(
                  '请选择要咨询的机构',
                  style: TextStyle(color: Color(0xff282828), fontSize: 17),
                ),
              ),
              Positioned(
                  right: 5,
                  top: 16.5,
                  child: Container(
                    width: 13.5,
                    height: 13.5,
                    child: Image.asset("assets/close-btn.png"),
                  ))
            ],
          ),
        ));
  }

  // 机构列表
  Widget mechanismList(mq, heigth) {
    return Container(
        height: heigth,
        width: mq.size.width,
        padding: EdgeInsets.only(left: 15, right: 15),
        child: baseRefreshView(refreshController, () {}, null, null,
            customScrollView: CustomScrollView(
              physics: ClampingScrollPhysics(),
              slivers: <Widget>[
                StreamBuilder<List<Hospitals>>(
                  stream: _model.cardsLive.stream,
                  initialData: _model.cardsLive.data ?? [],
                  builder: (c, data) {
                    if (data.data.isEmpty && _model.page > 1) {
                      refreshController.loadNoData();
                    } else {
                      refreshController.loadComplete();
                    }
                    return SliverList(
                      delegate: SliverChildBuilderDelegate(
                        (BuildContext context, int index) {
                          if (index == _model.data.length) {
                            return Container(
                              height: 0,
                              color: Color(0xffF7F6FA),
                            );
                          }
                          return HospitalItem(_model.data[index], index);
                        },
                        childCount: _model.data.length + 1,
                      ),
                    );
                  },
                ),
              ],
            ), onLoading: () {
          _model.loadMore();
        }, pullDown: false, pullUp: true));
  }

  // 机构卡片
  Widget HospitalItem(Hospitals hospital, index) {
    return GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: () {
          if (_model.doctor_ids.contains(hospital.doctorId)) {
            _model.doctor_ids.remove(hospital.doctorId);
            _model.hospital_ids.remove(hospital.hospitalId);
          } else {
            _model.doctor_ids.add(hospital.doctorId);
            _model.hospital_ids.add(hospital.hospitalId);
          }
          hospital.isCheck = !hospital.isCheck;
          focusNode.unfocus();
          _model.cardsLive.notifyView(_model.cardsLive.data);
          int length = _model.doctor_ids.length;
          if (length > 3 || length == 0) {
            NativeToast.showNativeToast('请选���1-3个机构咨询');
          }
        },
        child: Container(
          height: 91.5,
          decoration: BoxDecoration(
              border: Border(
                  bottom: BorderSide(width: .5, color: Color(0xffE5E5E5)))),
          child: Stack(
            children: <Widget>[
              Positioned(
                  left: 0,
                  top: 35,
                  child: Container(
                    height: 17,
                    width: 17,
                    child: hospital.isCheck
                        ? Image.asset("assets/icon-checked.png")
                        : Image.asset("assets/icon-check.png"),
                  )),
              Positioned(
                left: 32,
                top: 21,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(imageUrl: hospital.portrait),
                  ),
                ),
              ),
              Positioned(
                left: 89,
                top: 13,
                child: Container(
                  width: 230,
                  child: baseText(hospital.name, 15, Color(0xff282828)),
                ),
              ),
              Positioned(
                top: 38,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText(
                        hospital.minPrice == hospital.maxPrice
                            ? "${hospital.minPrice}"
                            : "${hospital.minPrice}-${hospital.maxPrice}",
                        15,
                        Color(0xffFF5963),
                        bold: true)
                  ],
                ),
              ),
              Positioned(
                bottom: 14,
                left: 89,
                child: Container(
                  width: 230,
                  child: baseText(hospital.address, 12, Color(0xff999999)),
                ),
              ),
              Positioned(
                left: 89,
                top: 40,
                child: FiveStarView(int.parse(hospital.star), 5),
              )
            ],
          ),
        ));
  }

  // 底部输入框部分
  Widget bottomMessage(context, bottomPadding) {
    return Container(
        height: 96 + bottomPadding,
        color: Color(0xffF9F8FB),
        child: Column(
          children: <Widget>[
            Container(
                height: 25,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12),
                child: Row(
                  children: <Widget>[
                    Container(
                        margin: EdgeInsets.only(left: 15, right: 8),
                        height: 25,
                        child: Text(
                          '我想',
                          style: TextStyle(
                              height: 2,
                              color: Color(0xff666666),
                              fontSize: 12),
                        )),
                    Expanded(
                      child: StreamBuilder<List<String>>(
                          stream: _model.questionsLive.stream,
                          initialData: _model.questionsLive.data ?? null,
                          builder: (c, e) {
                            if (e.data == null) {
                              return Container();
                            }
                            List<String> questions = e.data;
                            return ListView.builder(
                              scrollDirection: Axis.horizontal, //横向滚动
                              itemBuilder: (c, index) {
                                return GestureDetector(
                                  onTap: () {
                                    textController.text += questions[index];
                                    FocusScope.of(context)
                                        .requestFocus(focusNode);
                                  },
                                  child: Container(
                                    height: 25,
                                    margin: EdgeInsets.only(right: 12),
                                    padding: EdgeInsets.only(left: 8, right: 8),
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: Color(0xffE5E5E5),
                                            width: 0.5),
                                        color: Color(0xffffffff),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      questions[index],
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666),
                                          height: 1.8),
                                    ),
                                  ),
                                );
                              },
                              itemCount: questions.length,
                            );
                          }),
                    )
                  ],
                )),
            Container(
                height: 35,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12, left: 15, right: 15),
                padding: EdgeInsets.only(left: 16, right: 16),
                alignment: Alignment.centerLeft,
                decoration: BoxDecoration(
                    border: Border.all(color: Color(0xffE5E5E5), width: 0.5),
                    color: Color(0xffffffff),
                    borderRadius: BorderRadius.circular(35)),
                child: StreamBuilder(
                  stream: _model.messageLive.stream,
                  initialData: _model.messageLive.data ?? null,
                  builder: (context, snapshot) {
                    return TextField(
                        controller: textController,
                        keyboardType: TextInputType.text,
                        focusNode: focusNode,
                        textInputAction: TextInputAction.send,
                        onSubmitted: (txt) {
                          int length = _model.doctor_ids.length;
                          if (length > 3 || length == 0) {
                            NativeToast.showNativeToast('请选择1-3个机构咨询');
                          } else {
                            if (txt.isNotEmpty) {
                              _model.sendMessage(
                                  _model.doctor_ids.join(','),
                                  _model.hospital_ids.join(','),
                                  txt,
                                  plan_id, (i) {
                                if (i == 0) {
                                  dismissCall();
                                  textController.text = '';
                                  NativeToast.showNativeToast('消息已发送成功');
                                }
                              });
                            }
                          }
                        },
                        style:
                            TextStyle(fontSize: 14, color: Color(0xff282828)),
                        maxLines: 1,
                        textAlign: TextAlign.left,
                        decoration: InputDecoration(
                            contentPadding: EdgeInsets.only(top: -15),
                            hintText: '请输入您想了解的问题',
                            hintStyle: TextStyle(
                                color: Color(0xff999999), fontSize: 12),
                            border: InputBorder.none));
                  },
                ))
          ],
        ));
  }
}
