class ConsultHospitalsBean {
  int error;
  String message;
  Map extra;
  Map errorExtra;
  UserType userType;
  Data data;

  ConsultHospitalsBean(
      {this.error,
      this.message,
      this.extra,
      this.errorExtra,
      this.userType,
      this.data});

  ConsultHospitalsBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    errorExtra = json['error_extra'];
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    data['error_extra'] = this.errorExtra;
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}

class Data {
  List<Hospitals> hospitals;

  Data({this.hospitals});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['hospitals'] != null) {
      hospitals = new List<Hospitals>();
      json['hospitals'].forEach((v) {
        hospitals.add(new Hospitals.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.hospitals != null) {
      data['hospitals'] = this.hospitals.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Hospitals {
  String hospitalId;
  String doctorId;
  String portrait;
  String name;
  String minPrice;
  String maxPrice;
  String star;
  String address;
  String consultType;
  String messageUrl;
  bool isCheck = false;

  Hospitals(
      {this.hospitalId,
      this.doctorId,
      this.portrait,
      this.name,
      this.minPrice,
      this.maxPrice,
      this.star,
      this.address,
      this.consultType,
      this.messageUrl});

  Hospitals.fromJson(Map<String, dynamic> json) {
    hospitalId = json['hospital_id'];
    doctorId = json['doctor_id'];
    portrait = json['portrait'];
    name = json['name'];
    minPrice = json['min_price'];
    maxPrice = json['max_price'];
    star = json['star'];
    address = json['address'];
    consultType = json['consult_type'];
    messageUrl = json['message_url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hosiptal_id'] = this.hospitalId;
    data['doctor_id'] = this.doctorId;
    data['portrait'] = this.portrait;
    data['name'] = this.name;
    data['min_price'] = this.minPrice;
    data['max_price'] = this.maxPrice;
    data['star'] = this.star;
    data['address'] = this.address;
    data['consult_type'] = this.consultType;
    data['message_url'] = this.messageUrl;
    return data;
  }
}
