import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneListModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismModel.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class MechanismBox implements IBottomPicker {
  VoidCallback dismissCall;
  TextEditingController textController = TextEditingController();
  MechanismModel _model = new MechanismModel();
  List<String> doctor_ids = new List();

  LevelOneListModel _levelModel = LevelOneListModel();
  RefreshController refreshController = RefreshController();

  Function(String str) refresh;

  int _dateTime = DateTime.now().millisecondsSinceEpoch;

  FocusNode focusNode = new FocusNode();

  @required
  final int plan_id;

  MechanismBox(this.plan_id) : super();

  @override
  initState(dismissCall, BuildContext context) {
    this.dismissCall = dismissCall;
    _levelModel.plan_id = plan_id;
    _levelModel.tab_type = "hospital";
    _model.getQuestions(plan_id);
    _levelModel.refreshView(true);
    refresh = (str) {
      _levelModel.stateLive.notifyView(LOADING);
      _levelModel.refreshView(true);
    };
  }

  Widget build(BuildContext context) {
    MediaQueryData mq = MediaQuery.of(context);
    double keyHeight = MediaQuery.of(context).viewInsets.bottom;
    return Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.only(
              topLeft: Radius.circular(10.0), topRight: Radius.circular(10.0)),
          color: Colors.white,
        ),
        width: mq.size.width,
        height: mq.size.height - 140,
        child: StreamBuilder(
          stream: _model.stateLive.stream,
          initialData: _model.stateLive.data ?? LOADING,
          builder: (c, data) {
            if (data.data == FAIL) {
              return errorItem(MediaQuery.of(context).size.width,
                  MediaQuery.of(context).size.height, () {
                _model.getQuestions(plan_id);
              });
            }
            if (data.data == LOADING) {
              return loadingItem();
            }
            return setupHome(mq, keyHeight, context);
          },
        ));
  }

  @override
  void dispose() {
    focusNode.unfocus();
    Map<String, dynamic> map = {
      "business_id": "level_two_plan_compare_deatil",
      "page_name": "",
      "referrer": "",
      "referrer_id": "",
      "referrer_link": [],
      "referrer_tab_name": "",
      "in": "${_dateTime / 1000 / 1000}",
      "out": "${DateTime.now().millisecondsSinceEpoch / 1000 / 1000}",
      "is_push": 1,
      "fake": 1,
      "is_first": 1
    };
    RouterCenterImpl().findMainRouter().buriedEvent("page_view", map);
    textController.dispose();
    refreshController.dispose();
    _levelModel.dispose();
    _model.dispose();
    focusNode.dispose();
  }

  setupHome(mq, keyHeight, BuildContext context) {
    return Column(
      mainAxisSize: MainAxisSize.max,
      children: <Widget>[
        title(mq),
        StreamBuilder(
          stream: _levelModel.stateLive.stream,
          initialData: _levelModel.stateLive.data ?? LOADING,
          builder: (c, data) {
            if (data.data == LOADING) {
              return Container(
                width: MediaQuery.of(context).size.width,
                height: mq.size.height - 140 - 96 - 50 - keyHeight,
                child: loadingItem(),
              );
            }
            if (data.data == FAIL) {
              return errorItem(MediaQuery.of(context).size.width,
                  mq.size.height - 140 - 96 - 50 - keyHeight, () {
                _levelModel.refreshView(true);
              });
            }
            if (data.data == EMPTY) {
              return emptyItem(MediaQuery.of(context).size.width,
                      mq.size.height - 140 - 96 - 50 - keyHeight)
                  .gestureDetector(() {
                focusNode.unfocus();
              });
            }
            return mechanismList(mq, keyHeight);
          },
        ),
        bottomMessage()
      ],
    );
  }

  // 弹窗标题
  Widget title(mq) {
    return Container(
      margin: EdgeInsets.only(left: 15, right: 15),
      width: mq.size.width,
      decoration: BoxDecoration(
          border:
              Border(bottom: BorderSide(width: .5, color: Color(0xffE5E5E5)))),
      height: 50,
      child: Stack(
        alignment: Alignment.center,
        children: <Widget>[
          Container(
            child: Text(
              '请选择要咨询的机构',
              style: TextStyle(color: Color(0xff282828), fontSize: 17),
            ),
          ),
          Positioned(
              right: 5,
              top: 16.5,
              child: GestureDetector(
                onTap: () {
                  dismissCall();
                },
                child: Container(
                  width: 13.5,
                  height: 13.5,
                  child: Image.asset("assets/close-btn.png"),
                ),
              ))
        ],
      ),
    );
  }

  // 机构列表
  Widget mechanismList(mq, keyHeight) {
    return Container(
        height: mq.size.height - 140 - 96 - 50 - keyHeight,
        width: mq.size.width,
        padding: EdgeInsets.only(left: 15, right: 15),
        child: baseRefreshView(refreshController, () {}, null, null,
            customScrollView: CustomScrollView(
              physics: ClampingScrollPhysics(),
              slivers: <Widget>[
                StreamBuilder<List<Cards>>(
                  stream: _levelModel.cardsLive.stream,
                  initialData: _levelModel.cardsLive.data ?? [],
                  builder: (c, data) {
                    if (data.data.isEmpty && _levelModel.page > 1) {
                      refreshController.loadNoData();
                    } else {
                      refreshController.loadComplete();
                    }
                    return SliverList(
                      delegate: SliverChildBuilderDelegate(
                        (BuildContext context, int index) {
                          if (index == _levelModel.data.length) {
                            return Container(
                              height: 0,
                              color: Color(0xffF7F6FA),
                            );
                          }
                          if (_levelModel.data[index].cardType == 'hospital') {
                            return HospitalItem(
                                _levelModel.data[index].hospital);
                          } else {
                            return Container();
                          }
                        },
                        childCount: _levelModel.data.length + 1,
                      ),
                    );
                  },
                ),
              ],
            ), onLoading: () {
          _levelModel.loadMore();
        }, pullDown: false, pullUp: true));
  }

  // 机构卡片
  Widget HospitalItem(Hospital hospital) {
    return GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: () {
          if (doctor_ids.indexOf(hospital.doctorId) != -1) {
            doctor_ids.remove(hospital.doctorId);
          } else {
            doctor_ids.add(hospital.doctorId);
          }
          hospital.isCheck = !hospital.isCheck;
          focusNode.unfocus();
          _levelModel.cardsLive.notifyView(_levelModel.cardsLive.data);
        },
        child: Container(
          height: 91.5,
          decoration: BoxDecoration(
              border: Border(
                  bottom: BorderSide(width: .5, color: Color(0xffE5E5E5)))),
          child: Stack(
            children: <Widget>[
              Positioned(
                  left: 0,
                  top: 35,
                  child: Container(
                    height: 17,
                    width: 17,
                    child: hospital.isCheck
                        ? Image.asset("assets/icon-checked.png")
                        : Image.asset("assets/icon-check.png"),
                  )),
              Positioned(
                left: 32,
                top: 21,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(imageUrl: hospital.portrait),
                  ),
                ),
              ),
              Positioned(
                left: 89,
                top: 16,
                child: baseText(hospital.name, 15, Color(0xff333333)),
              ),
              Positioned(
                top: 38,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText("${hospital.minPrice}-${hospital.maxPrice}", 15,
                        Color(0xffFF5963),
                        bold: true),
                  ],
                ),
              ),
              Positioned(
                bottom: 16,
                left: 89,
                child: Container(
                  width: 230,
                  child: baseText(hospital.address, 12, Color(0xff666666)),
                ),
              ),
              Positioned(
                left: 89,
                top: 40,
                child: FiveStarView(int.parse(hospital.star), 5),
              )
            ],
          ),
        ));
  }

  // 底部输入框部分
  Widget bottomMessage() {
    return Container(
        height: 96,
        color: Color(0xffF9F8FB),
        child: Column(
          children: <Widget>[
            Container(
                height: 25,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12),
                child: Row(
                  children: <Widget>[
                    Container(
                        margin: EdgeInsets.only(left: 15, right: 8),
                        height: 25,
                        child: Text(
                          '我想',
                          style: TextStyle(
                              height: 2,
                              color: Color(0xff666666),
                              fontSize: 12),
                        )),
                    Expanded(
                      child: StreamBuilder<List<String>>(
                          stream: _model.questionsLive.stream,
                          initialData: _model.questionsLive.data ?? null,
                          builder: (c, e) {
                            if (e.data == null) {
                              return Container();
                            }
                            List<String> questions = e.data;
                            return ListView.builder(
                              scrollDirection: Axis.horizontal, //横向滚动
                              itemBuilder: (c, index) {
                                return GestureDetector(
                                  onTap: () {
                                    textController.text += questions[index];
                                  },
                                  child: Container(
                                    height: 25,
                                    margin: EdgeInsets.only(right: 12),
                                    padding: EdgeInsets.only(left: 8, right: 8),
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: Color(0xffE5E5E5),
                                            width: 0.5),
                                        color: Color(0xffffffff),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      questions[index],
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666),
                                          height: 1.8),
                                    ),
                                  ),
                                );
                              },
                              itemCount: questions.length,
                            );
                          }),
                    )
                  ],
                )),
            Container(
                height: 35,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12, left: 15, right: 15),
                decoration: BoxDecoration(
                    border: Border.all(color: Color(0xffE5E5E5), width: 0.5),
                    color: Color(0xffffffff),
                    borderRadius: BorderRadius.circular(35)),
                child: StreamBuilder(
                  stream: _model.messageLive.stream,
                  initialData: _model.messageLive.data ?? null,
                  builder: (context, snapshot) {
                    return TextField(
                        controller: textController,
                        keyboardType: TextInputType.text,
                        focusNode: focusNode,
                        textInputAction: TextInputAction.send,
                        onSubmitted: (txt) {
                          if (doctor_ids.length > 3 || doctor_ids.length < 1) {
                            NativeToast.showNativeToast('请选择1-3个机构咨询');
                          } else {
                            if (txt.isNotEmpty) {
                              _model.sendMessage(
                                  doctor_ids.join(','), txt, plan_id, (i) {
                                if (i == 0) {
                                  dismissCall();
                                  textController.text = '';
                                  NativeToast.showNativeToast('消息已发送成功');
                                }
                              });
                            }
                          }
                        },
                        style:
                            TextStyle(fontSize: 14, color: Color(0xff282828)),
                        maxLines: 1,
                        decoration: InputDecoration(
                            contentPadding: EdgeInsets.only(
                                left: 16, top: 0, bottom: 11.5, right: 16),
                            hintText: '请输入您想了解的问题',
                            hintStyle: TextStyle(
                                color: Color(0xff999999),
                                fontSize: 12,
                                height: 2.2),
                            border: InputBorder.none));
                  },
                ))
          ],
        ));
  }
}
