/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/ProjectDetailsItem.dart';

class ProjectDetailsItemView extends StatelessWidget {
  Groups listData;

  ProjectDetailsItemView(this.listData);

  @override
  Widget build(BuildContext context) {
    List<Widget> tiles = [];
    for (var item in listData.attrs) {
      tiles.add(getItem(item));
    }
    var column = Column(
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(left: 15.0),
          margin: EdgeInsets.only(bottom: 16.0),
          alignment: Alignment.centerLeft,
          width: double.maxFinite,
          height: 55,
          decoration: BoxDecoration(
              image: DecorationImage(
                  image: AssetImage("assets/bg_project_detail_item.png"),
                  fit: BoxFit.cover)),
          child: Text(
            listData.name,
            style: TextStyle(
              fontWeight: FontWeight.bold,
              color: Color(0xFF000000),
              fontSize: 15.0,
            ),
          ),
        ),
        Column(
          children: tiles,
        )
      ],
    );
    return Container(
      margin: EdgeInsets.only(bottom: 5),
      child: column,
    );
  }

  getItem(Attrs attrs) {
    var row = Container(
      width: double.maxFinite,
      margin: EdgeInsets.only(bottom: 25, left: 15, right: 15),
      child: Row(
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(right: 25.0),
            alignment: Alignment.centerLeft,
            width: 78,
            child: Text(
              attrs.attrName,
              style: TextStyle(
                color: Color(0xFF999999),
                fontSize: 13.0,
              ),
            ),
          ),
          Container(
            alignment: Alignment.centerLeft,
            child: Text(
              attrs.attrValue,
              style: TextStyle(
                color: Color(0xFF282828),
                fontSize: 14.0,
              ),
            ),
          ),
        ],
      ),
    );
    return Container(
      child: row,
    );
  }
}
