/*
 * @Author: zx 
 * @Date: 2020-07-03 13:53:16 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-03 18:24:55
 */
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseCenterPicker.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class DiscussLowPricePopView {
  static void showPopView(BuildContext content) {
    BaseCenterPicker()
      ..setPicker(_PopView())
      ..show(content);
  }
}

class _PopView implements ICenterPicker {
  VoidCallback dismissCallback;

  @override
  Widget build(BuildContext context, int alp) {
    return Container(
        width: 304,
        height: 292,
        alignment: Alignment.center,
        child: ClipRRect(
            borderRadius: BorderRadius.circular(10), child: setupBodyView()));
  }

  setupBodyView() {
    return Container(
        color: Colors.white,
        child: Stack(alignment: AlignmentDirectional.center, children: <Widget>[
          Positioned(
              top: -42.5,
              width: 85,
              height: 85,
              child: Container(
                color: Colors.blue,
                alignment: Alignment.topCenter,
                child: Image.asset('assets/plan_compare_detail_info_bg.png',
                    fit: BoxFit.cover),
              )),
          Positioned(
            width: 14,
            height: 14,
            top: 20,
            right: 20,
            // bottom: 25,
            child: Container(
                child: GestureDetector(
              onTap: () {},
              child: Image.asset('assets/discuss_loe_price_cancel.png',
                  fit: BoxFit.cover),
            )),
          ),
          Positioned(
            width: 235,
            top: 42.5,
            // bottom: 25,
            child: Container(
              alignment: Alignment.center,
              child: detailView(),
            ),
          )
        ]));
  }

  detailView() {
    return Container(
      child: Column(
          mainAxisSize: MainAxisSize.min,
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Positioned(
                child: Container(
              width: 146,
              height: 19,
              margin: EdgeInsets.only(bottom: 14),
              alignment: AlignmentDirectional.center,
              child: Row(children: <Widget>[
                Positioned(
                  left: 0,
                  child: Image.asset('assets/discuss_loe_price_like.png'),
                ),
                Positioned(
                    left: 20,
                    child: baseText('对当前商品感兴趣？', 14, Color(0xff848484)))
              ]),
            )),
            Positioned(
                child: Container(
                    width: 235,
                    margin: EdgeInsets.only(bottom: 25),
                    child: baseText('机构可免费为您提供咨询服务', 18, Color(0xff464646),
                        bold: true))),
            Positioned(
                child: ClipRRect(
                    borderRadius: BorderRadius.circular(7),
                    child: Container(
                        alignment: Alignment.center,
                        margin: EdgeInsets.only(bottom: 12),
                        width: 235,
                        height: 37,
                        color: Color(0xffECECEC),
                        child:
                            baseText('13800138000', 16, Color(0xff484848))))),
            Positioned(
                child: ClipRRect(
                    borderRadius: BorderRadius.circular(7),
                    child: GestureDetector(
                        onTap: () {
                          // FlutterBoost.singleton.closeByContext(context);
                        },
                        child: Container(
                            alignment: Alignment.center,
                            margin: EdgeInsets.only(bottom: 14),
                            width: 235,
                            height: 37,
                            // color: Colors.red,
                            child: Image.asset(
                                'assets/discuss_loe_price_auth.png'))))),
            Positioned(
                child: Container(
                    width: 235,
                    margin: EdgeInsets.only(bottom: 25),
                    child: baseText(
                        '授权后，您的手机将以“虚拟号”方式提供给机构', 11, Color(0xff999999)))),
          ]),
    );
  }

  @override
  void dispose() {}

  @override
  void initState(VoidCallback dismissCall, BuildContext context) {
    this.dismissCallback = dismissCall;
  }
}
