/*
 * @Author: zx 
 * @Date: 2020-07-03 20:54:59 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-04 12:20:45
 */
import 'package:dio/dio.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/ClueModel/server/entity/DiscussLowPriceModelBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/DiscussLowPriceAuthBean.dart';

class DiscussLowPriceModel extends BaseModel {
  LiveData<Pair<int, DiscussLowPriceModelBean>> popViewLive = LiveData();
  RxDispose rxDispose = RxDispose();

  fetchPopviewData(String planId, String hospitalId, String doctorId) {
    ClueApiImpl.getInstance()
        .getPopviewData(
            DioUtil.getInstance().getDio(), planId, hospitalId, doctorId)
        .listen((event) {
          if (event.error == 0) {
            if (event.data == null) {
              popViewLive.notifyView(Pair(ENDLOADING, null));
            } else {
              popViewLive.notifyView(Pair(ENDLOADING, event.data));
            }
          } else {
            NativeToast.showNativeToast(event.message);
            popViewLive.notifyView(Pair(FAIL, null));
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          popViewLive.notifyView(Pair(FAIL, null));
          NativeToast.showNativeToast(err.message);
        });
  }

  givePhoneAuth(int leadPhoneRequestId, VoidCallback callback) {
    popViewLive.notifyView(Pair(LOADING, null));
    ClueApiImpl.getInstance()
        .givePhoneAuth(DioUtil.getInstance().getDio(), leadPhoneRequestId)
        .listen((event) {
          if (event.error == 0) {
          } else {
            NativeToast.showNativeToast(event.message);
          }
          callback();
        })
        .addToDispose(rxDispose)
        .onError((err) {
          NativeToast.showNativeToast(err.message);
          callback();
        });
  }

  @override
  void dispose() {
    popViewLive.dispost();
    rxDispose.dispose();
  }
}
