/*
 * @author lsy
 * @date   2020/5/14
 **/
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';

import 'DioUtil.dart';

class DioInterceptorManager {
  static DioInterceptorManager _interceptorManager;

  DioInterceptorManager._() {}

  static DioInterceptorManager getInstance() {
    if (_interceptorManager == null) {
      _interceptorManager = new DioInterceptorManager._();
    }
    return _interceptorManager;
  }

  InterceptorsWrapper getIntercept() {
    return new InterceptorsWrapper(onRequest: (opt) {
      if (CacheManager.getInstance().get(SHARE_CACHE).get(NET_COOKIE) != null) {
        if (opt.headers == null) {
          opt.headers = Map();
        }
        opt.headers[HttpHeaders.cookieHeader] =
            CacheManager.getInstance().get(SHARE_CACHE).get(NET_COOKIE);
      }
      print("请求之前  onRequest${opt.headers}");
    }, onResponse: (response) {
      print("响应之前  onResponse${response}");
    }, onError: (e) {
      print("网络错误  $e message ${e.message}");
    });
  }

  String formatError(DioError e) {
    String reason = "";
    if (e.type == DioErrorType.CONNECT_TIMEOUT) {
      // It occurs when url is opened timeout.
      reason = "连接超时 ${e.message}";
    } else if (e.type == DioErrorType.SEND_TIMEOUT) {
      // It occurs when url is sent timeout.
      reason = "请求超时 ${e.message}";
    } else if (e.type == DioErrorType.RECEIVE_TIMEOUT) {
      //It occurs when receiving timeout
      reason = "响应超时 ${e.message}";
    } else if (e.type == DioErrorType.RESPONSE) {
      // When the server response, but with a incorrect status, such as 404, 503...
      reason = "出现异常 ${e.message}";
    } else if (e.type == DioErrorType.CANCEL) {
      // When the request is cancelled, dio will throw a error with this type.
      reason = "请求取消 ${e.message}";
    } else {
      //DEFAULT Default error type, Some other Error. In this case, you can read the DioError.error if it is not null.
      reason = "未知错误 ${e.message}";
    }
    return reason;
  }
}
