import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlansCompareFeed.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

class PlansCompareFeedModel extends BaseModel {
  LiveData<PlansCompareFeed> liveData = LiveData();
  RxDispose rxDispose = RxDispose();

  void init(int _planType, int _planId) {
    ClueApiImpl.getInstance()
        .getPlansCompareFeed(DioUtil.getInstance().getDio(), _planId, _planType)
        .listen((event) {
          liveData.notifyView(event);
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
        });
  }

  @override
  void dispose() {
    liveData.dispost();
    rxDispose.dispose();
  }
}
