/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueTApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanOverViewBean.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/NativeToast.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

class LevelOneModel extends BaseModel {
  LiveData<int> stateLive = LiveData();
  LiveData<double> textLive = LiveData();

  RxDispose rxDispose = RxDispose();

  List<Tabs> tabsList = [];
  int plan_id = 0;
  PlanOverData planoverItem;

  void init(VoidCallback callback) {
    ClueTApiImpl.getInstance()
        .getPlanOverView(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            planoverItem = event.data;
            tabsList = event.data.tabs;
            stateLive.notifyView(ENDLOADING);
            callback();
          } else {
            NativeToast.showNativeToast(event.message);
            stateLive.notifyView(FAIL);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
          stateLive.notifyView(FAIL);
        });
  }

  int currentIndex = 0;

  @override
  void dispose() {
    stateLive.dispost();
    textLive.dispost();
  }

  void selectTab(int index) {}
}
