/*
 * @author dx
 * @date   2020/6/29
 **/
import 'dart:async';
import 'dart:ui';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:extended_nested_scroll_view/extended_nested_scroll_view.dart'
    as extend;
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:gm_flutter/ClueModel/page/DiscussLowPrice/DiscussLowPricePopView.dart';
import 'package:gm_flutter/ClueModel/page/common/StickyTabBarDelegate.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneList.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneModel.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismBoxPage.dart';
import 'package:gm_flutter/commonModel/App.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/cache/CacheManager.dart';
import 'package:gm_flutter/commonModel/eventbus/SimpleEventBus.dart';
import 'package:gm_flutter/commonModel/view/baseRefreshIndicator.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class LevelTwoPage extends StatefulWidget {
  int planId;
  final String PAGE_NAME = "level_two_plan_deatil";

  LevelTwoPage(Map<String, dynamic> params) {
    planId = params['planId'];
  }

  @override
  State<StatefulWidget> createState() => LevelTwoState();
}

class LevelTwoState extends BaseState<LevelTwoPage>
    with TickerProviderStateMixin {
  LevelOneModel _model = new LevelOneModel();
  RefreshController _refreshController = RefreshController();
  GlobalKey keyTop = new GlobalKey();
  GlobalKey key1 = new GlobalKey();
  double screenWidth;
  List<Widget> oneList = new List();
  int lastPageIndex = 0;

  TabController tabController;

  int index = 0;

  @override
  void initState() {
    super.initState();
    _model.plan_id = widget.planId;
    _model.init(() {
      _initTabBar();
    });
  }

  void _initTabBar() {
    if (tabController != null) {
      tabController.removeListener(tabControlerListener);
    }
    tabController = TabController(
        initialIndex: index, length: _model.tabsList.length, vsync: this);
    tabController.addListener(tabControlerListener);
    setState(() {});
  }

  @override
  void dispose() {
    tabController?.removeListener(tabControlerListener);
    tabController?.dispose();
    _model.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  void tabControlerListener() {
    if (index != tabController.index) {
      index = tabController.index;
    }
  }

  @override
  Widget buildItem(BuildContext context) {
    oneList.clear();
    oneList.add(good());
    oneList.add(rect());
    oneList.add(explain());
    oneList.add(Container(
      height: 5,
      color: Color(0xffF7F6FA),
    ));
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
        backgroundColor: Colors.white,
        body: SafeArea(
            top: false,
            child: baseStateView(
                MediaQuery.of(context).size.width,
                MediaQuery.of(context).size.height,
                _model.stateLive,
                Container(
                    child: Column(
                  children: <Widget>[
                    Expanded(
                      child: BaseNestedScrollViewRefreshIndicator(
                          onRefresh: () async {
                            Completer completer = new Completer();
                            _model.init(() {
                              _initTabBar();
                              SimpleEventBus.instance()
                                  .notifyListener("LevelOneList", "");
                              completer.complete();
                            });
                            return completer.future;
                          },
                          child: newHomeWarp()),
                    ),
                    Container(
                      height: 0.5,
                      width: double.maxFinite,
                      color: Color(0xffE5E5E5),
                    ),
                    bottomWidget(),
                  ],
                )), () {
              _model.stateLive.notifyView(LOADING);
              _model.init(() {
                _initTabBar();
              });
            },
                paddingTop: MediaQueryData.fromWindow(window).padding.top +
                    kToolbarHeight)));
  }

  Widget newHomeWarp() {
    return Stack(
      children: <Widget>[
        Container(
            width: MediaQuery.of(context).size.width,
            height: MediaQuery.of(context).size.height,
            child: NotificationListener(
              onNotification: (scrollNotification) {
                if (scrollNotification is KeepAliveNotification ||
                    scrollNotification is OverscrollIndicatorNotification) {
                  return false;
                }
                if (scrollNotification is ScrollUpdateNotification &&
                    scrollNotification.metrics.axisDirection.index == 2) {}
                if (scrollNotification.depth == 0) {
                  if (scrollNotification.metrics.pixels > 80) {
                    _model.textLive.notifyView(
                        (scrollNotification.metrics.pixels - 80) / 40 > 1.0
                            ? 1.0
                            : (scrollNotification.metrics.pixels - 80) / 40);
                  } else {
                    _model.textLive.notifyView(0.0);
                  }
                } else if (scrollNotification.depth == 2) {
                  if (scrollNotification.metrics.pixels < 50 &&
                      scrollNotification.metrics.pixels > 0) {
                    _model.textLive.notifyView(1.0);
                  }
                }
                return false;
              },
              child: newHome(),
            )),
        baseSliverTitle("${_model.name}", MediaQuery.of(context).size.width,
            _model.textLive, context),
        baseSliverBack(() {
          if (RouterCenterImpl().findMainRouter().isWithNative()) {
            FlutterBoost.singleton.closeCurrent();
          } else {
            Navigator.of(context).pop();
          }
        }, context),
      ],
    );
  }

  Widget newHome() {
    List<Widget> list = [];
    var d = MediaQueryData.fromWindow(window).padding.top;
    for (int i = 0; i < _model.tabsList.length; i++) {
      list.add(extend.NestedScrollViewInnerScrollPositionKeyWidget(
          Key("Tab${i}"),
          LevelOneList(
              1,
              widget.PAGE_NAME,
              widget.planId,
              _model.tabsList[i].tabType,
              _model.tabsList[i].name,
              kToolbarHeight + d)));
    }
    final double statusBarHeight = MediaQuery.of(context).padding.top;
    final double pinnedHeaderHeight = statusBarHeight + kToolbarHeight;
    return extend.NestedScrollView(
        innerScrollPositionKeyBuilder: () {
          String index = 'Tab${tabController.index.toString()}';
          return Key(index);
        },
        headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
          return <Widget>[
            SliverOverlapAbsorber(
                handle: extend.NestedScrollView.sliverOverlapAbsorberHandleFor(
                    context),
                sliver: baseSliverAppBar(_model.imageUrl,
                    height: 0, needpic: false)),
            SliverList(
                delegate: SliverChildBuilderDelegate((BuildContext c, int i) {
              if (i == 0) {
                return Container(
                  height: pinnedHeaderHeight,
                );
              }
              return oneList[i - 1];
            }, childCount: oneList.length + 1)),
            SliverPersistentHeader(
              pinned: true,
              delegate: StickyTabBarDelegate(
                  child: Container(
                height: 40,
                color: Colors.white,
                child: baseTabBar(tabController, getTabs(), (index) {
                  _model.selectTab(index, _model.tabsList[index].name,
                      _model.tabsList[_model.currentIndex].name);
                  _model.currentIndex = index;
                }, scroll: false),
              )),
            ),
          ];
        },
        body: Container(
            color: Color(0xffF7F6FA),
            child: TabBarView(controller: tabController, children: list)));
  }

  List<Widget> getTabs() {
    List<Widget> list = [];
    for (int i = 0; i < _model.tabsList.length; i++) {
      list.add(baseTabBarItem(_model.tabsList[i].name));
    }
    return list;
  }

  Widget good() {
    if (_model.planoverItem == null) {
      return Container(
        height: 54,
      );
    }
    return Padding(
      padding: EdgeInsets.only(left: 15.0, right: 15.0, bottom: 20),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.max,
        children: <Widget>[
          ClipRRect(
            borderRadius: BorderRadius.circular(6),
            child: Container(
              color: Color(0xffF9F8FB),
              width: 86,
              height: 86,
              padding: EdgeInsets.all(1),
              child: ClipRRect(
                  borderRadius: BorderRadius.circular(6),
                  child: Container(
                    width: 86,
                    height: 86,
                    color: Colors.white,
                    child: CachedNetworkImage(
                      imageUrl: _model.planoverItem.banner.imageUrl,
                      width: 86,
                      height: 86,
                      fit: BoxFit.cover,
                    ),
                  )),
            ),
          ),
          Expanded(
            child: Padding(
                padding: EdgeInsets.only(left: 12, top: 5),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisSize: MainAxisSize.max,
                  children: <Widget>[
                    Text(_model.planoverItem.name,
                        style: TextStyle(
                            color: Color(0xff333333),
                            fontSize: 15,
                            fontWeight: FontWeight.bold)),
                    Padding(padding: EdgeInsets.only(top: 5)),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      verticalDirection: VerticalDirection.up,
                      children: <Widget>[
                        Text('指导价：',
                            style: TextStyle(
                                color: Color(0xff999999), fontSize: 12)),
                        Expanded(
                          child: baseText(_model.planoverItem.guidePrice, 12,
                              Color(0xffFF5963)),
                        )
                      ],
                    )
                  ],
                )),
          )
        ],
      ),
    );
  }

  Widget rect() {
    if (_model.planoverItem == null) {
      return Container(
        height: 62,
      );
    }
    List<Widget> list = List();
    int i = 0;
    _model.planoverItem.overviewAttrs.forEach((element) {
      list.add(Expanded(
        child: Container(
          alignment: Alignment.center,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(left: 2, right: 2),
                child: baseText(element.attrValue, 14, Color(0xff282828),
                    bold: true),
              ),
              baseText(element.attrName, 11, Color(0xff999999)),
            ],
          ),
        ),
      ));
      if (i != _model.planoverItem?.overviewAttrs.length - 1) {
        list.add(Container(
          width: 0.5,
          height: 18,
          color: Color(0xFFE5E5E5),
        ));
      }
      i++;
    });
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Color(0xffF9F8FB),
      ),
      width: double.maxFinite,
      height: 62,
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 17),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: list,
      ),
    );
  }

  Widget explain() {
    List<Widget> list = [];
    list.add(Row(
      children: <Widget>[
        baseText("项目说明", 15, Color(0xff282828), bold: true),
        Expanded(
          child: Container(),
        ),
        GestureDetector(
          onTap: () {
            Map<String, dynamic> map = {
              "business_id": "${widget.planId}",
              "referrer_tab_name": _model.tabsList[tabController.index].name,
              "planId": widget.planId
            };
            RouterCenterImpl()
                .findMainRouter()
                .jumpPage(context, "level_two_plan_instruction", map, false);
          },
          behavior: HitTestBehavior.opaque,
          child: baseText("了解更多", 12, Color(0xff3FB5AF)),
        )
      ],
    ));
    list.add(Container(
      height: 11,
    ));
    if (_model.planoverItem != null) {
      _model.planoverItem.explanationAttrs.forEach((element) {
        List<Widget> textList = [];
        if (element.attrName.length < 4) {
          for (int i = 0; i < element.attrName.length; i++) {
            textList.add(baseText(
                element.attrName.substring(i, i + 1), 13, Color(0xff999999)));
            if (i < element.attrName.length - 1) {
              textList.add(Expanded(
                child: Container(),
              ));
            }
          }
        }
        list.add(Container(
          margin: EdgeInsets.only(bottom: 10),
          child: Row(
            children: <Widget>[
              Container(
                  width: 53.5,
                  child: element.attrName.length < 4
                      ? Row(
                          children: textList,
                        )
                      : baseText(element.attrName, 13, Color(0xff999999))),
              Expanded(
                child: Container(
                  margin: EdgeInsets.only(left: 12),
                  child: Text(
                    element.attrValue,
                    textScaleFactor: 1.0,
                    softWrap: false,
                    overflow: TextOverflow.ellipsis,
                    style: TextStyle(
                        decoration: TextDecoration.none,
                        fontSize: 13,
                        color: Color(0xff666666),
                        fontStyle: FontStyle.normal,
                        fontWeight: FontWeight.w400),
                  ),
//                baseText(element.attrValue, 13, Color(0xff666666)
//                ),
                ),
              )
            ],
          ),
        ));
      });
    }
    return Container(
      margin: EdgeInsets.only(left: 15, right: 15, bottom: 9),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: list,
      ),
    );
  }

  // 底部按钮
  Widget bottomWidget() {
    return Container(
      width: double.maxFinite,
      height: 55,
      color: Colors.white,
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          GestureDetector(
            behavior: HitTestBehavior.opaque,
            onTap: () {
              Map<String, dynamic> map = {
                "business_id": "${widget.planId}",
                "referrer_tab_name": _model.tabsList[tabController.index].name,
                "planId": widget.planId,
                "planType": 2
              };
              RouterCenterImpl()
                  .findMainRouter()
                  .jumpPage(context, "level_two_plan_compare", map, false);
            },
            child: Container(
              margin: EdgeInsets.only(left: 21, right: 20),
              width: 30,
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  Container(
                    width: 22,
                    height: 22,
                    child: Image.asset("assets/vs_black.png"),
                  ),
                  Container(
                    margin: EdgeInsets.only(top: 3),
                    child: baseText("去比较", 10, Color(0xff282828)),
                  )
                ],
              ),
            ),
          ),
          Expanded(
            child: GestureDetector(
                behavior: HitTestBehavior.opaque,
                onTap: () {
                  if (CacheManager.getInstance()
                              .get(MEMORY_CACHE)
                              .get(USER_ID) ==
                          null &&
                      RouterCenterImpl().findMainRouter().isWithNative()) {
                    RouterCenterImpl()
                        .findMainRouter()
                        .jumpPage(context, "show_login", null, true);
                    return;
                  }
                  BaseBottomPicker()
                    ..setPicker(MechanismBox(widget.planId, widget.PAGE_NAME))
                    ..show(context);
                },
                child: Container(
                  height: 40,
                  decoration: BoxDecoration(
                      color: Color(0xff51CDC7),
                      borderRadius: BorderRadius.circular(20)),
                  alignment: Alignment.center,
                  child: baseText("咨询", 14, Colors.white, bold: true),
                )),
          ),
          Container(
            width: 15,
          ),
          Expanded(
              child: GestureDetector(
                  behavior: HitTestBehavior.opaque,
                  onTap: () {
                    if (CacheManager.getInstance()
                                .get(MEMORY_CACHE)
                                .get(USER_ID) ==
                            null &&
                        RouterCenterImpl().findMainRouter().isWithNative()) {
                      RouterCenterImpl()
                          .findMainRouter()
                          .jumpPage(context, "show_login", null, true);
                      return;
                    }
                    DiscussLowPricePopView.showPopView(
                        context, widget.PAGE_NAME, "${widget.planId}", "", "");
                  },
                  child: Container(
                    height: 40,
                    decoration: BoxDecoration(
                        color: Color(0xffF96079),
                        borderRadius: BorderRadius.circular(20)),
                    alignment: Alignment.center,
                    child: baseText("获取底价", 14, Colors.white, bold: true),
                  ))),
          Container(
            width: 15,
          ),
        ],
      ),
    );
  }
}
