/*
 * @author lsy
 * @date   2019-10-13
 **/

import 'dart:io';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/view/baseTabIndicator.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:lottie/lottie.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

double SCREENWIDTH;
double SCREENHEIGHT;

AppBar baseAppBar(
    {String title,
    List<Widget> action,
    bool centerTitle,
    VoidCallback backClick,
    Color backgroundColor,
    Key key,
    bool showBack = true,
    double elevation = 0.0,
    Widget titleWidget = null}) {
  return _baseAppBarChangeTitle(
      title:
          title == null ? Container() : baseText(title, 18, Color(0xff323232)),
      action: action,
      centerTitle: centerTitle,
      backClick: backClick,
      backgroundColor: backgroundColor,
      key: key,
      showBack: showBack,
      elevation: elevation,
      titleWidget: titleWidget);
}

AppBar _baseAppBarChangeTitle(
    {Widget title,
    List<Widget> action,
    bool centerTitle,
    VoidCallback backClick,
    Color backgroundColor,
    Key key,
    bool showBack,
    double elevation,
    Widget titleWidget}) {
  return AppBar(
    key: key,
//    backgroundColor:
//        backgroundColor == null ? ALColors.ColorFFFFFF : backgroundColor,
    title: titleWidget == null ? title : titleWidget,
    centerTitle: centerTitle,
    elevation: elevation,
    leading: showBack
        ? GestureDetector(
            behavior: HitTestBehavior.opaque,
            onTap: backClick,
            child: Hero(
                tag: "left_arrow",
                child: Container(
                    alignment: Alignment.centerLeft,
                    margin: EdgeInsets.only(left: 7),
                    child: Container(
                      width: 30,
                      height: 30,
                      child: Image.asset(
                        "assets/left_arrow.png",
                        color: Color(0xff323232),
                      ),
                    ))),
          )
        : Container(),
    actions: action == null ? List<Widget>() : action,
  );
}

Text baseText(String text, double fontSize, Color color,
    {bool bold = false,
    TextAlign textAlign,
    int maxLines = 1,
    TextOverflow overflow,
    bool isWarp = false}) {
  return Text(
    text,
    textAlign: textAlign ?? TextAlign.start,
    textScaleFactor: 1.0,
    softWrap: isWarp,
    style: TextStyle(
        decoration: TextDecoration.none,
        fontSize: fontSize,
        color: color,
        fontStyle: FontStyle.normal,
        fontWeight: bold ? FontWeight.w600 : FontWeight.w400),
    maxLines: maxLines,
    overflow: overflow == null ? TextOverflow.ellipsis : overflow,
  );
}

Widget baseDivide(double padding) {
  return Container(
    height: 0.5,
    width: double.maxFinite,
    margin: EdgeInsets.only(left: padding, right: padding),
    color: Color(0xffE5E5E5),
  );
}

Widget baseDivideWidth(double width, double padding) {
  return Container(
    height: 0.5,
    width: width,
    margin: EdgeInsets.only(left: padding, right: padding),
    color: Color(0xffE5E5E5),
  );
}

Widget loadingItem({bool needBackground = false}) {
//  return
//    Center(
//      child: Container(
//    width: 77,
//    height: 77,
//    decoration: BoxDecoration(
//        borderRadius: BorderRadius.circular(8),
//        color: needBackground ? Colors.black : Colors.transparent),
//    alignment: Alignment.center,
//    child: MyCupertinoActivityIndicator(
//      backColor: needBackground ? Colors.white : Colors.black,
//    ),
//  ));
  return Center(
    child: Container(
      width: 80,
      height: 80,
      child: Lottie.asset("assets/smart_refresh_header.json",
          repeat: true, reverse: false),
    ),
  );
}

Widget netErrorItem() {}

Widget errorItem(double width, double height, VoidCallback retry,
    {String errorText, String retryText, double paddingTop}) {
  return Container(
      color: Colors.white,
      width: width,
      height: height,
      padding: EdgeInsets.only(top: paddingTop ?? 0),
      alignment: Alignment.topCenter,
      child: Container(
          width: 180,
          height: 315.5,
          margin: EdgeInsets.only(top: 62),
          child: Column(
            children: <Widget>[
              Container(
                width: 180,
                height: 186.5,
                child: Stack(
                  alignment: AlignmentDirectional.center,
                  children: <Widget>[
                    Positioned(
                      left: 0,
                      top: 0,
                      child: Container(
                        width: 180,
                        height: 186.5,
                        child: Image.asset("assets/error.png"),
                      ),
                    ),
                    Positioned(
                      top: 166,
                      child: Container(
                        width: 180,
                        alignment: Alignment.center,
                        child: baseText(
                            errorText ?? "原谅我一看到美人就不淡定", 15, Color(0xff666666)),
                      ),
                    ),
                  ],
                ),
              ),
              Container(
                width: 150,
                height: 40,
                margin: EdgeInsets.only(top: 17),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(20),
                    gradient: LinearGradient(
                        colors: [Color(0xFFFF5963), Color(0xffFF7096)],
                        begin: FractionalOffset(1, 0),
                        end: FractionalOffset(0, 1))),
                alignment: Alignment.center,
                child: baseText(retryText ?? "重新加载", 16, Colors.white),
              ).gestureDetector(() {
                retry();
              }),
              Container(
                width: 150,
                height: 40,
                margin: EdgeInsets.only(top: 20),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(20),
                    border: Border.all(color: Color(0xffFF5963), width: 0.5)),
                alignment: Alignment.center,
                child: baseText("检查网络设置", 16, Color(0xffFF5963)),
              ).gestureDetector(() {
                RouterCenterImpl().findMainRouter().jumpToSetting();
              }),
            ],
          )));
}
//TODO

Widget refreshViewTop(RefreshController refreshController, VoidCallback refresh,
    Widget topFix, Widget List) {
  return SmartRefresher(
      enablePullDown: true,
      enablePullUp: false,
      header: WaterDropMaterialHeader(
        backgroundColor: Color.fromARGB(255, 236, 236, 236),
      ),
      controller: refreshController,
      onRefresh: refresh,
      child: CustomScrollView(
        slivers: <Widget>[
          SliverToBoxAdapter(
            child: topFix,
          ),
          List
        ],
      ));
}

Widget refreshViewbottom(RefreshController refreshController,
    VoidCallback refresh, Widget topFix, Widget List) {
  return SmartRefresher(
      enablePullDown: true,
      enablePullUp: false,
      header: WaterDropMaterialHeader(
        backgroundColor: Color.fromARGB(255, 236, 236, 236),
      ),
      controller: refreshController,
      onRefresh: refresh,
      child: CustomScrollView(
        slivers: <Widget>[
          List,

//          SliverToBoxAdapter(
//            child: topFix,
//          ),
        ],
      ));
}

Widget baseTextField(TextEditingController editingController,
    TextInputType inputType, String hintText) {
  return TextField(
    cursorColor: Color(0xff20BDBB),
    style: TextStyle(fontSize: 14),
    decoration: InputDecoration(
      hintText: hintText,
      hintStyle: TextStyle(fontSize: 14, color: Color(0xffCCCCCC)),
      isDense: true,
      border: InputBorder.none,
      contentPadding:
          const EdgeInsets.symmetric(horizontal: 0.0, vertical: 17.0),
    ),
    maxLines: 1,
    enableInteractiveSelection: true,
    autocorrect: false,
    autofocus: true,
    keyboardType: inputType,
    controller: editingController,
    minLines: 1,
  );
}

Widget baseRedPoint(int num) {
  return Container(
    alignment: Alignment.center,
    width: 15,
    height: 15,
    decoration: BoxDecoration(shape: BoxShape.circle, color: Color(0xffFF5963)),
    child: baseText("${num}", 11, Color(0xffFFFFFF)),
  );
}

Widget baseRefreshView(RefreshController refreshController,
    VoidCallback refresh, Widget topFix, Widget List,
    {bool pullUp = false,
    bool pullDown = true,
    VoidCallback onLoading,
    ScrollController scrollController,
    Widget customScrollView,
    Color loadMoreColor}) {
  return SmartRefresher(
      enablePullDown: pullDown,
      enablePullUp: pullUp,
      onLoading: onLoading ?? () {},
      header: normalRefreshHeader(),
      controller: refreshController,
      onRefresh: refresh,
      footer: CustomFooter(
        builder: (BuildContext context, LoadStatus mode) {
          Widget body = Container();
//          print("LOAD STATUE ${mode}");
//          if (mode == LoadStatus.idle) {
//            body = baseText("上拉加载更多", 12, Color(0xff545454));
//          } else if (mode == LoadStatus.loading) {
//            body = baseText("加载中", 12, Color(0xff545454));
//          } else if (mode == LoadStatus.failed) {
//            body = baseText("加载失败", 12, Color(0xff545454));
//          } else
          if (mode == LoadStatus.noMore) {
            body = baseText("我们是有底线的", 12, Color(0xff999999));
          }
//          else {
//            body = Container();
//          }
          if (mode == LoadStatus.loading) {
            body = Lottie.asset("assets/smart_refresh_header.json",
                repeat: true, reverse: false);
          }
          return Container(
            color: loadMoreColor ?? Colors.white,
            height: 55.0,
            child: Center(child: body),
          );
        },
      ),
      child: customScrollView ??
          CustomScrollView(
            controller: scrollController,
            slivers: <Widget>[
              SliverToBoxAdapter(
                child: topFix,
              ),
              List,
            ],
          ));
}

Widget normalRefreshHeader() {
  return CustomHeader(
    builder: (BuildContext context, RefreshStatus mode) {
      Widget body = Container();
//          if (mode == RefreshStatus.idle) {
//
//          } else
      if (mode == RefreshStatus.refreshing) {
//        body = ImagesAnimation(
//            w: 46,
//            h: 15,
//            durationSeconds: 1500,
//            entry: ImagesAnimationEntry(1, 20, "assets/ptr_header_loading"));

        body = Lottie.asset("assets/smart_refresh_header.json",
            repeat: true, reverse: false);
      }
//            else if (mode == RefreshStatus.failed) {
//            body = Text("Load Failed!Click retry!");
//          }
      else {
//        body = Image.asset(
//          "assets/ptr_header_loading01.png",
//          width: 46,
//          height: 15,
//        );
      }
      return Container(
        height: 55.0,
        child: Center(child: body),
      );
    },
  );
}

Widget emptyItem(double width, double height,
    {String detail, double paddingTop}) {
  return Container(
    padding: EdgeInsets.only(top: paddingTop ?? 0),
    width: width,
    height: height,
    color: Colors.white,
    alignment: Alignment.topCenter,
    child: Container(
        width: 175,
        height: 188,
        margin: EdgeInsets.only(top: 62.5),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: <Widget>[
            Container(
              width: 175,
              height: 188,
              child: Stack(
                alignment: AlignmentDirectional.bottomCenter,
                children: <Widget>[
                  Container(
                    width: 175,
                    height: 188,
                    child: Image.asset("assets/empty.png"),
                  ),
                  Positioned(
                    bottom: 17,
                    child: baseText(
                        detail ?? "此处太寂寥，转转别处吧", 15, Color(0xff666666)),
                  )
                ],
              ),
            ),
            Container(
              height: 0,
              color: Colors.white,
            )
          ],
        )),
  );
}

Widget baseTabBar(
    TabController controller, List<Widget> list, Function(int index) clickItem,
    {BaseIndicator baseIndicator, double fontSize, Color color, bool scroll}) {
  return Container(
      decoration: BoxDecoration(
        color: Colors.white,
        boxShadow: [
          BoxShadow(
              color: Color(0x08000000),
              offset: Offset(0.0, 2.0),
              blurRadius: 12,
              spreadRadius: 0)
        ],
      ),
      child: TabBar(
        onTap: clickItem,
        controller: controller,
        indicatorSize: TabBarIndicatorSize.tab,
        isScrollable: scroll ?? true,
        unselectedLabelColor: color ?? Color(0xffB5B5B5),
        labelColor: color ?? Color(0xff282828),
        labelStyle:
            TextStyle(fontSize: fontSize ?? 16, fontWeight: FontWeight.w600),
        unselectedLabelStyle:
            TextStyle(fontSize: fontSize ?? 16, fontWeight: FontWeight.w600),
        labelPadding: EdgeInsets.only(),
        indicator: baseIndicator ?? BaseIndicator(),
        tabs: list,
      ));
}

Widget baseTabBarItem(String text,
    {double leftPadding,
    double rightPadding,
    double wantWidth,
    bool isScroll = false}) {
  leftPadding = leftPadding ?? 14.0;
  rightPadding = rightPadding ?? 14.0;
  return isScroll
      ? Row(
          mainAxisSize: MainAxisSize.min,
          children: <Widget>[
            Container(
              width: leftPadding,
            ),
            Tab(
              text: text,
            ),
            Container(
              width: rightPadding,
            )
          ],
        )
      : Center(
          child: Tab(
            text: text,
          ),
        );
//    Container(
//    height: 40.0,
//    width: wantWidth ?? width,
//    alignment: Alignment.center,
//    child: Tab(
//      text: text,
//    ),
//  );
}

Widget baseSliverAppBar(String url,
    {double height, double elevation, bool needpic = true, double paddingTop}) {
  return SliverAppBar(
    pinned: true,
    centerTitle: true,
    elevation: elevation ?? 0,
    expandedHeight: height ?? 200,
    automaticallyImplyLeading: false,
    bottom: PreferredSize(
      preferredSize: Size.fromHeight(paddingTop ?? -12),
      child: SizedBox(
        height: 0,
      ),
    ),
    flexibleSpace: FlexibleSpaceBar(
      background: needpic
          ? CachedNetworkImage(
              imageUrl: url ?? '',
              fit: BoxFit.fitHeight,
            )
          : Container(),
    ),
  );
}

Widget baseSliverBack(VoidCallback tap, context) {
  final double topPadding = MediaQuery.of(context).padding.top;
  return Positioned(
    top: topPadding + 6.5,
    left: 15,
    child: GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: tap,
        child: Container(
          width: 30,
          height: 30,
          decoration:
              BoxDecoration(color: Color(0x99FFFFFF), shape: BoxShape.circle),
          alignment: Alignment.center,
          child: Hero(
            tag: "baseSliverBack",
            child: Container(
              child: Image.asset("assets/left_arrow.png"),
            ),
          ),
        )),
  );
}

Widget baseSliverTitle(String text, double width, LiveData liveData, context) {
  final double topPadding = MediaQuery.of(context).padding.top;
  return Positioned(
    top: topPadding + 9.5,
    child: StreamBuilder(
      stream: liveData.stream,
      initialData: liveData.data ?? 0.0,
      builder: (c, data) {
        return Opacity(
          opacity: data.data,
          child: Container(
            alignment: Alignment.center,
            width: width,
            child: baseText(text, 18, Color(0xff333333), bold: true),
          ),
        );
      },
    ),
  );
}

Widget baseStateView(double width, double height, LiveData<int> stateLive,
    Widget home, VoidCallback retry,
    {double paddingTop}) {
  return StreamBuilder(
    stream: stateLive.stream,
    initialData: stateLive.data ?? LOADING,
    builder: (c, data) {
      if (data.data == LOADING) {
        return Container(
          color: Colors.white,
          child: loadingItem(),
        );
      } else if (data.data == FAIL) {
        return errorItem(width, height, retry, paddingTop: paddingTop);
      } else if (data.data == EMPTY) {
        return emptyItem(width, height, paddingTop: paddingTop);
      }
      return home;
    },
  );
}
