/*
 * @Author: zx 
 * @Date: 2020-07-03 13:53:16 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-03 20:49:16
 */
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseCenterPicker.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class DiscussLowPricePopView {
  static void showPopView(BuildContext content) {
    BaseCenterPicker()
      ..setPicker(_PopView())
      ..show(content);
  }
}

class _PopView implements ICenterPicker {
  VoidCallback dismissCallback;

  @override
  Widget build(BuildContext context, int alp) {
    return Container(
        width: 304,
        alignment: Alignment.center,
        child: Container(
            child: Container(
          margin: EdgeInsets.fromLTRB(0, 0, 0, 0),
          child: Stack(children: <Widget>[
            Column(
                mainAxisSize: MainAxisSize.min,
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Container(
                    height: 42.5,
                    width: 304,
                  ),
                  Container(
                      margin: EdgeInsets.only(bottom: 0),
                      child: Stack(children: <Widget>[
                        Container(
                          child: setupBodyView(),
                        ),
                        Container(
                            margin: EdgeInsets.only(top: 20, left: 274),
                            width: 14,
                            height: 14,
                            child: GestureDetector(
                              onTap: () {},
                              child: Image.asset(
                                  'assets/discuss_loe_price_cancel.png',
                                  fit: BoxFit.cover),
                            ))
                      ]))
                ]),
            Container(
              alignment: Alignment.center,
              margin: EdgeInsets.only(top: 0, left: 109.5),
              width: 85,
              height: 85,
              color: Colors.red,
              child: Image.asset('assets/discuss_loe_price_cancel.png',
                  fit: BoxFit.cover),
            )
          ]),
        )));
  }

  setupBodyView() {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(7),
        color: Colors.white,
      ),
      child: Container(
        alignment: Alignment.center,
        margin: EdgeInsets.only(bottom: 0, top: 42.5),
        child: detailView(),
      ),
    );
  }

  detailView() {
    return Container(
      child: Column(
          mainAxisSize: MainAxisSize.min,
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Container(
              height: 19,
              margin: EdgeInsets.only(bottom: 14),
              alignment: AlignmentDirectional.center,
              child: Row(mainAxisSize: MainAxisSize.min, children: <Widget>[
                Container(
                    width: 16,
                    height: 16,
                    child: Image.asset('assets/discuss_loe_price_like.png')),
                Container(
                  margin: EdgeInsets.only(left: 4),
                  child: baseText('对当前商品感兴趣？', 14, Color(0xff848484)),
                )
              ]),
            ),
            Container(
                width: 235,
                margin: EdgeInsets.only(bottom: 25),
                child: baseText('机构可免费为您提供咨询服务', 18, Color(0xff464646),
                    bold: true)),
            Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(7),
                  color: Color(0xffECECEC),
                ),
                alignment: Alignment.center,
                margin: EdgeInsets.only(bottom: 12),
                width: 235,
                height: 37,
                child: baseText('13800138000', 16, Color(0xff484848))),
            Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(7),
                ),
                child: GestureDetector(
                    onTap: () {
                      // FlutterBoost.singleton.closeByContext(context);
                    },
                    child: Container(
                        alignment: Alignment.center,
                        margin: EdgeInsets.only(bottom: 14),
                        width: 235,
                        height: 37,
                        child:
                            Image.asset('assets/discuss_loe_price_auth.png')))),
            Container(
                width: 235,
                margin: EdgeInsets.only(bottom: 25),
                child:
                    baseText('授权后，您的手机将以“虚拟号”方式提供给机构', 11, Color(0xff999999))),
          ]),
    );
  }

  @override
  void dispose() {}

  @override
  void initState(VoidCallback dismissCall, BuildContext context) {
    this.dismissCallback = dismissCall;
  }
}
