/*
 * @author lsy
 * @date   2020/6/30
 **/
import 'dart:io';
import 'dart:math';
import 'dart:ui';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/levelTwo/LevelTwoPage.dart';
import 'package:gm_flutter/ClueModel/page/plan/FilterView.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanBar.dart';
import 'package:gm_flutter/ClueModel/page/plan/PlanItem.dart';
import 'package:gm_flutter/ClueModel/page/plan/SortView.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/ClueModel/util/PosUtil.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/popMenu/BaseMenuListener.dart';
import 'package:gm_flutter/commonModel/popMenu/BasePopMenu.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/util/WidgetUtil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'PlanModel.dart';
import 'ProjectView.dart';

class PlanPage extends StatefulWidget {

  @override
  State<StatefulWidget> createState() => PlanState();
}

class PlanState extends BaseState<PlanPage> with TickerProviderStateMixin {
  PlanModel _model = PlanModel();
  TextEditingController _editingController = TextEditingController();
  FocusNode focusNode = FocusNode();
  RefreshController refreshController = RefreshController();
  List<Widget> planList = List();

  BaseMenuListener projectMenuListener = BaseMenuListener();
  BaseMenuListener sortMenuListener = BaseMenuListener();
  BaseMenuListener filterMenuListener = BaseMenuListener();
  ChangeNotifier hideAllMenuListener = new ChangeNotifier();
  GlobalKey globalKey = GlobalKey();
  PlanBarView planBarView;

  @override
  void initState() {
    super.initState();
    _model.init();
    planBarView =
        PlanBarView(_model.managerLive, clickIndex, hideAllMenuListener);
    planList.add(towPic().toActive());
    planList.add(planBar().toActive());
    planList.add(pages());
  }

  @override
  void dispose() {
    hideAllMenuListener.dispose();
    projectMenuListener.dispose();
    sortMenuListener.dispose();
    filterMenuListener.dispose();
    _model.dispose();
    focusNode.dispose();
    refreshController.dispose();
    _editingController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
        body: MediaQuery.removePadding(
      removeTop: true,
      context: context,
      child: SafeArea(
        top: false,
        child: Stack(
          children: <Widget>[
            Container(
              width: MediaQuery.of(context).size.width,
              height: MediaQuery.of(context).size.height,
              child: Column(
                children: <Widget>[
                  head(),
                  Expanded(
                    child: Stack(
                      children: <Widget>[
                        Container(
                          width: MediaQuery.of(context).size.width,
                          height: MediaQuery.of(context).size.height - 86,
                          child: child(),
                        ),
                        StreamBuilder<List<double>>(
                            stream: _model.backLive.stream,
                            initialData: [0.0, 0.0, 0.0],
                            builder: (c, data) {
                              return Positioned(
                                left: 0.0,
                                top: 0.0,
                                child: Visibility(
                                  visible: data.data[2] > 0.1,
                                  child: Container(
                                    width: MediaQuery.of(context).size.width,
                                    height: MediaQuery.of(context).size.height,
                                    child: Column(
                                      children: <Widget>[
                                        Container(
                                          height: data.data[1] - 45 < 0
                                              ? 0
                                              : data.data[1] - 45,
                                          color: Colors.transparent,
                                        ),
                                        Container(
                                          height: 45,
                                          child: Row(
                                            children: <Widget>[
                                              Expanded(
                                                child: Container()
                                                    .gestureDetector(() {
                                                  clickIndexOther(0);
                                                }),
                                              ),
                                              Expanded(
                                                child: Container()
                                                    .gestureDetector(() {
                                                  clickIndexOther(1);
                                                }),
                                              ),
                                              Expanded(
                                                child: Container()
                                                    .gestureDetector(() {
                                                  clickIndexOther(2);
                                                }),
                                              ),
                                            ],
                                          ),
                                        ),
                                        Expanded(
                                          child: Container(
                                            color: Color.fromARGB(
                                                (data.data[2] * 153).toInt(),
                                                0,
                                                0,
                                                0),
                                          ).gestureDetector(() {
                                            hideAllMenuListener
                                                .notifyListeners();
                                          }),
                                        )
                                      ],
                                    ),
                                  ),
                                ),
                              );
                            }),
                        StreamBuilder<List<double>>(
                            stream: _model.posLive.stream,
                            initialData: [0.0, 0.0],
                            builder: (c, data) {
                              return BasePopMenu(
                                leftPos: data.data[0],
                                topPos: data.data[1],
                                width: MediaQuery.of(context).size.width,
                                maxHeight: 450,
                                listener: projectMenuListener,
                                child: ProjectView(_model.projectData, (id) {
                                  clickIndexOther(0);
                                  _model.projectClick(id);
                                }),
                                proListener: (pro) {
                                  _model.backProgress(pro, 0);
                                },
                              );
                            }),
                        StreamBuilder<List<double>>(
                          stream: _model.posLive.stream,
                          initialData: [0.0, 0.0],
                          builder: (c, data) {
                            return BasePopMenu(
                              leftPos: data.data[0],
                              topPos: data.data[1],
                              width: MediaQuery.of(context).size.width,
                              maxHeight: 272,
                              listener: sortMenuListener,
                              child: SortView(_model.sortList, _model.sortPos,
                                  (index) {
                                clickIndexOther(1);
                                _model.sortClick(index);
                              }),
                              proListener: (pro) {
                                _model.backProgress(pro, 1);
                              },
                            );
                          },
                        ),
                        StreamBuilder<List<double>>(
                            stream: _model.posLive.stream,
                            initialData: [0.0, 0.0],
                            builder: (c, data) {
                              return BasePopMenu(
                                leftPos: data.data[0],
                                topPos: data.data[1],
                                width: MediaQuery.of(context).size.width,
                                maxHeight: 186,
                                listener: filterMenuListener,
                                child: FilterView((max, min) {
                                  clickIndexOther(2);
                                  _model.filterClick(max, min);
                                }),
                                proListener: (pro) {
                                  _model.backProgress(pro, 2);
                                },
                              );
                            }),
                        StreamBuilder<bool>(
                          stream: _model.showTab.stream,
                          initialData: _model.showTab.data ?? false,
                          builder: (c, data) {
                            return Visibility(
                              visible: data.data,
                              child: Container(
                                color: Colors.white,
                                child: planBarView,
                              ),
                            );
                          },
                        )
                      ],
                    ),
                  )
                ],
              ),
            ),
            StreamBuilder(
              stream: _model.stateLive.stream,
              initialData: _model.stateLive.data ?? LOADING,
              builder: (c, data) {
                if (data.data == LOADING) {
                  return Container(
                    width: MediaQuery.of(context).size.width,
                    height: MediaQuery.of(context).size.height,
                    color: Colors.white,
                    child: loadingItem(),
                  );
                } else if (data.data == FAIL) {
                  return errorItem(
                    MediaQuery.of(context).size.width,
                    MediaQuery.of(context).size.height,
                    () {
                      _model.stateLive.notifyView(LOADING);
                      _model.init();
                    },
                  );
                } else {
                  return Container(
                    width: 0,
                    height: 0,
                  );
                }
              },
            )
          ],
        ),
      ),
    ));
  }

  Widget head() {
    return Container(
      height: 86,
      child: Container(
        margin: EdgeInsets.only(top: 48, left: 15, right: 15),
        width: double.maxFinite,
        height: 32,
        child: TextField(
          cursorColor: Color(0xff20BDBB),
          style: TextStyle(fontSize: 12, color: Color(0xff999999)),
          decoration: InputDecoration(
              isDense: true,
              prefixIcon: Container(
                child: Container(
                  margin: EdgeInsets.only(left: 12, right: 6),
                  width: 13,
                  height: 13,
                  child: Image.asset("assets/search.png"),
                ),
              ),
              prefixIconConstraints:
                  BoxConstraints(maxWidth: 31, minWidth: 31, maxHeight: 13),
              suffixIconConstraints:
                  BoxConstraints(maxWidth: 56.5, maxHeight: 32),
              suffixIcon: Container(
                decoration: BoxDecoration(
                  color: Color(0xff51CDC7),
                  borderRadius: BorderRadius.circular(16),
                ),
                alignment: Alignment.center,
                child: baseText("搜索", 14, Colors.white),
              ).gestureDetector(() {
                //TODO
              }),
              contentPadding:
                  const EdgeInsets.symmetric(horizontal: 12.0, vertical: 10.0),
              border: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(19.5),
                  borderSide: BorderSide.none),
              filled: true,
              fillColor: Color(0xffF7F6FA),
              hintStyle: TextStyle(fontSize: 12, color: Color(0xff999999)),
              hintText: "切开双眼皮"),
          maxLines: 1,
          enableInteractiveSelection: true,
          focusNode: focusNode,
          autocorrect: false,
          autofocus: false,
          textInputAction: TextInputAction.search,
          controller: _editingController,
          minLines: null,
          onEditingComplete: () {},
          onSubmitted: (text) {},
        ),
      ),
    );
  }

  Widget child() {
    return NotificationListener(
        onNotification: (scrollNotification) {
          if (scrollNotification is ScrollUpdateNotification &&
              scrollNotification.metrics.axisDirection.index == 2) {
            _onScroll(scrollNotification.metrics.pixels);
          }
          return false;
        },
        child: baseRefreshView(
            refreshController,
            () {
              _model.refreshFeed(true);
            },
            Container(
              width: 0,
              height: 0,
            ),
            SliverList(
              delegate: SliverChildBuilderDelegate(
                (BuildContext context, int index) {
                  return planList[index];
                },
                childCount: planList.length,
              ),
            ),
            onLoading: () {
              _model.loadMore();
            },
            pullUp: true));
  }

  Widget towPic() {
    return Container(
      height: 90,
      margin: EdgeInsets.only(left: 15, right: 15, top: 15, bottom: 10),
      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              child: StreamBuilder<List<Ranks>>(
                stream: _model.picLive.stream,
                initialData: _model.picLive.data ?? null,
                builder: (c, data) {
                  return ClipRRect(
                      borderRadius: BorderRadius.circular(3),
                      child: CachedNetworkImage(
                        imageUrl:
                            data.data == null ? "" : data.data[0].icon ?? "",
                        fit: BoxFit.cover,
                      )).gestureDetector(() {
                    //TODO
                  });
                },
              ),
            ),
          ),
          Container(
            width: 10,
          ),
          Expanded(
            child: Container(
              child: StreamBuilder<List<Ranks>>(
                stream: _model.picLive.stream,
                initialData: _model.picLive.data ?? null,
                builder: (c, data) {
                  return ClipRRect(
                      borderRadius: BorderRadius.circular(3),
                      child: CachedNetworkImage(
                        imageUrl:
                            data.data == null ? "" : data.data[1].icon ?? "",
                        fit: BoxFit.cover,
                      )).gestureDetector(() {
                    //TODO
                  });
                },
              ),
            ),
          )
        ],
      ),
    );
  }

  Widget planBar() {
    return Container(
      key: globalKey,
      child: planBarView,
    );
  }

  void clickIndexOther(int index) {
    if (index == planBarView.showIndex) {
      planBarView.showIndex = -1;
    } else {
      planBarView.showIndex = index;
    }
    _model.managerLive
        .notifyView(_model.managerLive.data ?? planBarView.normalData);
    clickIndex(planBarView.showIndex);
  }

  void clickIndex(int index) {
    var topPos = PosUtil.findPos(globalKey);

    double bottom =
//        WidgetUtil.buttonLeftMenuPosition(globalKey.currentContext)?.top ??
        topPos == null ? 0.0 : topPos.dy + 45 - 86;
    if (bottom < 45) {
      bottom = 45;
    }
    _model.menuBottom = bottom;
    if (_model.menuIndex == index || _model.menuIndex == -1) {
      _model.needChangBack = true;
    } else {
      _model.needChangBack = false;
    }
    _model.menuIndex = index;
    _model.posLive.notifyView([0.0, bottom]);
    if (index == -1) {
      projectMenuListener.hide();
      sortMenuListener.hide();
      filterMenuListener.hide();
    } else if (index == 0) {
      projectMenuListener.show();
      sortMenuListener.hide();
      filterMenuListener.hide();
    } else if (index == 1) {
      projectMenuListener.hide();
      sortMenuListener.show();
      filterMenuListener.hide();
    } else if (index == 2) {
      projectMenuListener.hide();
      sortMenuListener.hide();
      filterMenuListener.show();
    }
  }

  Widget pages() {
    return StreamBuilder<Pair<int, List<Plans>>>(
      stream: _model.feedsLive.stream,
      initialData: _model.feedsLive.data ?? Pair(LOADING, null),
      builder: (c, data) {
        double height = MediaQuery.of(context).size.height - 131;
        if (_model.feedDatas != null && _model.feedDatas.length > 0) {
          height = max(_model.feedDatas.length * 100.0, height);
        }
        return Container(
            color: Color(0xffF7F6FA),
            width: double.maxFinite,
            height: height,
            child: ListView.builder(
              physics: NeverScrollableScrollPhysics(),
              itemBuilder: (c, index) {
                if (data.data.first == FAIL) {
                  return errorItem(MediaQuery.of(context).size.width, height,
                      () {
                    _model.refreshFeed(true);
                  });
                }
                if (data.data.first == LOADING) {
                  return loadingItem();
                }
                if (data.data.second.length == 0) {
                  if (_model.page == 1) {
                    return emptyItem(MediaQuery.of(context).size.width, height);
                  } else {
                    refreshController.loadNoData();
                  }
                } else {
                  refreshController.loadComplete();
                }
                return PlanItem(_model.feedDatas[index]);
              },
              itemCount: _model.feedDatas.length,
            ));
      },
    );
  }

  void _onScroll(double offset) {
    var topPos = PosUtil.findPos(globalKey);
    if (topPos != null) {
      if (topPos.dy > 86) {
        _model.showTab.notifyView(false);
      } else {
        _model.showTab.notifyView(true);
      }
    }
//    if (topPos != null && topPos.dy < 0) {
//      double dy = -topPos.dy;
//      if (dy < 20) {
//        dy = 0;
//      }
//      double alpha = dy / 112;
//      if (alpha < 0) {
//        alpha = 0;
//      } else if (alpha > 1) {
//        alpha = 1;
//      }
//      _model.showTab.notifyView(alpha);
  }
}
