/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/ProjectDetails/ProjectDetailsItemView.dart';
import 'package:gm_flutter/ClueModel/page/ProjectDetails/ProjectDetailsModel.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

import '../../server/entity/ProjectDetailsItem.dart';

class ProjectDetailsPage extends StatefulWidget {
  int _planId;

  @override
  State<StatefulWidget> createState() => _ProjectDetailsState();
}

class _ProjectDetailsState extends BaseState<ProjectDetailsPage> {
  ProjectDetailsModel _model;

  @override
  void initState() {
    super.initState();
    _model = new ProjectDetailsModel();
    _model.init(widget._planId);
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      appBar: baseAppBar(
          title: "项目说明",
          centerTitle: true,
          backClick: () {
            Navigator.pop(context);
          }),
      body: Center(
        child: getBody(),
      ),
    );
  }

  getBody() {
    return StreamBuilder(
      stream: _model.liveData.stream,
      initialData: _model.liveData.data ?? null,
      builder: (c, data) {
        if (_model.liveData.data == null) {
          return loadingItem();
        }
        ProjectDetailsItem item = data.data;
        if (item == null || item.data == null || item.data.groups == null) {
          return emptyItem(MediaQuery
              .of(context)
              .size
              .width,
              MediaQuery
                  .of(context)
                  .size
                  .height);
        }
        if (item.error != 0) {
          return errorItem(MediaQuery
              .of(context)
              .size
              .width,
              MediaQuery
                  .of(context)
                  .size
                  .height, () {});
        }
        return ListView.builder(
            itemCount: item.data.groups.length,
            itemBuilder: (BuildContext context, int position) {
              return ProjectDetailsItemView(item.data.groups[position]);
            });
      },
    );
  }
}
