/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class LevelOneModel extends BaseModel {
  LiveData<double> appBarLive = LiveData();
  LiveData<List<String>> rectLive = LiveData();
  LiveData<List<String>> explainLive = LiveData();
  LiveData<bool> showTab = LiveData();
  LiveData<int> topIndexLive = new LiveData();
  LiveData<double> topScrollLive = new LiveData();
  RxDispose rxDispose = RxDispose();
  LiveData<Pair<int,List<Cards>>> cardsLive = LiveData();

  Map<int, List<Cards>> data = new Map();
  List list = ["plan", "hospital", "doctor", "diary"];
  List pageList = [1, 1, 1, 1];

  void refreshView(bool clear, {RefreshController refreshListener}) {
    int index = currentIndex;
    if (clear) {
      data.clear();
      pageList = [1, 1, 1, 1];
    }
    ClueApiImpl.getInstance()
        .getLevelOneList(
        DioUtil.getInstance().getDio(), 123, list[index], pageList[index])
        .listen((event) {

    }).addToDispose(rxDispose).onError((err) {

    });
  }

  int currentIndex = 0;

  @override
  void dispose() {
    showTab.dispost();
    cardsLive.dispost();
    appBarLive.dispost();
    rectLive.dispost();
    topIndexLive.dispost();
    topScrollLive.dispost();
  }

  void selectPage(int index) {
    if (currentIndex == index) {
      return;
    }
    currentIndex = index;
  }
}
