/*
 * @author dx
 * @date 2020-06-29
 **/

import 'package:flutter/material.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

class LevelTwoPage extends StatefulWidget {
  @override
  _LevelTwoPageState createState() => _LevelTwoPageState();
}

class _LevelTwoPageState extends BaseState<LevelTwoPage>
    with SingleTickerProviderStateMixin {
  TabController tabController;

  @override
  void initState() {
    super.initState();
    this.tabController = TabController(length: 2, vsync: this);
  }

  @override
  Widget buildItem(BuildContext context) {
    return Scaffold(
      body: CustomScrollView(
        slivers: <Widget>[
          SliverAppBar(
            pinned: true,
            elevation: 0,
            expandedHeight: 250,
            flexibleSpace: FlexibleSpaceBar(title: Text('二级方案')),
          ),
          SliverPersistentHeader(
            pinned: true,
            delegate: StickyTabBarDelegate(
              child: TabBar(
                labelColor: Color(0xff282828),
                labelStyle:
                    TextStyle(fontSize: 15.0, fontWeight: FontWeight.bold),
                labelPadding: EdgeInsets.only(top: 15.0),
                unselectedLabelColor: Color(0xffB5B5B5),
                unselectedLabelStyle: TextStyle(fontSize: 15.0),
                indicatorColor: Color(0xff4ABAB4),
                indicatorWeight: 3.0,
                indicatorSize: TabBarIndicatorSize.label,
                indicatorPadding: EdgeInsets.only(left: 5.0, right: 5.0),
                controller: this.tabController,
                tabs: <Widget>[
                  Tab(text: '医院'),
                  Tab(text: '医生'),
                ],
              ),
            ),
          ),
          SliverFillRemaining(
            child: TabBarView(
              controller: this.tabController,
              children: <Widget>[
                Center(child: Text('医院列表')),
                Center(child: Text('医生列表')),
              ],
            ),
          ),
        ],
      ),
    );
  }
}

class StickyTabBarDelegate extends SliverPersistentHeaderDelegate {
  final TabBar child;

  StickyTabBarDelegate({@required this.child});

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    return this.child;
  }

  @override
  double get maxExtent => this.child.preferredSize.height;

  @override
  double get minExtent => this.child.preferredSize.height;

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) {
    return true;
  }
}
