/*
 * @author lsy
 * @date   2019-10-13
 **/

import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:flutter_common/commonModel/eventbus/GlobalEventBus.dart';
import 'package:flutter_common/commonModel/view/iOSLoading.dart';
import 'package:flutter_svg/svg.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/commonModel/view/ImagesAnimation.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

double SCREENWIDTH;
double SCREENHEIGHT;

AppBar baseAppBar(
    {String title,
    List<Widget> action,
    bool centerTitle,
    VoidCallback backClick,
    Color backgroundColor,
    Key key,
    bool showBack = true,
    double elevation = 0.0,
    Widget titleWidget = null}) {
  return _baseAppBarChangeTitle(
      title:
          title == null ? Container() : baseText(title, 16, Color(0xff323232)),
      action: action,
      centerTitle: centerTitle,
      backClick: backClick,
      backgroundColor: backgroundColor,
      key: key,
      showBack: showBack,
      elevation: elevation,
      titleWidget: titleWidget);
}

AppBar _baseAppBarChangeTitle(
    {Widget title,
    List<Widget> action,
    bool centerTitle,
    VoidCallback backClick,
    Color backgroundColor,
    Key key,
    bool showBack,
    double elevation,
    Widget titleWidget}) {
  return AppBar(
    key: key,
//    backgroundColor:
//        backgroundColor == null ? ALColors.ColorFFFFFF : backgroundColor,
    title: titleWidget == null ? title : titleWidget,
    centerTitle: centerTitle,
    elevation: elevation,
    leading: showBack
        ? GestureDetector(
            behavior: HitTestBehavior.opaque,
            onTap: backClick,
            child: Hero(
                tag: "left_arrow",
                child: Container(
                    alignment: Alignment.centerLeft,
                    margin: EdgeInsets.only(left: 10),
                    child: Container(
                      width: 30,
                      height: 30,
                      child: Image.asset(
                        "images/left_arrow.png",
                        color: Color(0xff323232),
                      ),
                    ))),
          )
        : Container(),
    actions: action == null ? List<Widget>() : action,
  );
}

Text baseText(String text, double fontSize, Color color, {bool bold = false}) {
  return Text(
    text,
    textScaleFactor: 1.0,
    style: TextStyle(
        decoration: TextDecoration.none,
        fontSize: fontSize,
        color: color,
        fontStyle: FontStyle.normal,
        fontWeight: bold ? FontWeight.w500 : FontWeight.w400),
  );
}

Widget baseDivide(double padding) {
  return Container(
    height: 0.5,
    width: double.maxFinite,
    margin: EdgeInsets.only(left: padding, right: padding),
    color: Color(0xffE5E5E5),
  );
}

Widget baseDivideWidth(double width, double padding) {
  return Container(
    height: 0.5,
    width: width,
    margin: EdgeInsets.only(left: padding, right: padding),
    color: Color(0xffE5E5E5),
  );
}

Widget loadingItem({bool needBackground = false}) {
  return Center(
      child: Container(
    width: 77,
    height: 77,
    decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: needBackground ? Colors.black : Colors.transparent),
    alignment: Alignment.center,
    child: MyCupertinoActivityIndicator(
      backColor: needBackground ? Colors.white : Colors.black,
    ),
  ));
}

Widget netErrorItem() {}

Widget errorItem(VoidCallback retry, {String errorText, String retryText}) {
  return Container(
      width: SCREENWIDTH,
      height: SCREENHEIGHT,
      color: Colors.white,
      alignment: Alignment.center,
      child: Container(
          height: SCREENHEIGHT,
          child: Container(
            margin: EdgeInsets.only(top: 70),
            width: 175,
            height: 249,
            child: Stack(
              children: <Widget>[
                Positioned(
                  left: 0,
                  top: 0,
                  child: Container(
                    width: 175,
                    height: 199,
                    child: Image.asset("assets/error.png"),
                  ),
                ),
                Positioned(
                  left: 0,
                  top: 166,
                  child: Container(
                    width: 175,
                    alignment: Alignment.center,
                    child: baseText(errorText ?? "网络错误", 15, Color(0xff666666)),
                  ),
                ),
                Positioned(
                  top: 216,
                  left: 12,
                  child: Container(
                    width: 150,
                    height: 33,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(22.5),
                        color: Color(0xff51CDC7)),
                    alignment: Alignment.center,
                    child: baseText(retryText ?? "重新加载", 16, Colors.white),
                  ).gestureDetector(() {
                    retry();
                  }),
                )
              ],
            ),
          )));
}
//TODO

Widget refreshViewTop(RefreshController refreshController, VoidCallback refresh,
    Widget topFix, Widget List) {
  return SmartRefresher(
      enablePullDown: true,
      enablePullUp: false,
      header: WaterDropMaterialHeader(
        backgroundColor: Color.fromARGB(255, 236, 236, 236),
      ),
      controller: refreshController,
      onRefresh: refresh,
      child: CustomScrollView(
        slivers: <Widget>[
          SliverToBoxAdapter(
            child: topFix,
          ),
          List
        ],
      ));
}

Widget refreshViewbottom(RefreshController refreshController,
    VoidCallback refresh, Widget topFix, Widget List) {
  return SmartRefresher(
      enablePullDown: true,
      enablePullUp: false,
      header: WaterDropMaterialHeader(
        backgroundColor: Color.fromARGB(255, 236, 236, 236),
      ),
      controller: refreshController,
      onRefresh: refresh,
      child: CustomScrollView(
        slivers: <Widget>[
          List,

//          SliverToBoxAdapter(
//            child: topFix,
//          ),
        ],
      ));
}

Widget baseTextField(TextEditingController editingController,
    TextInputType inputType, String hintText) {
  return TextField(
    cursorColor: Color(0xff20BDBB),
    style: TextStyle(fontSize: 14),
    decoration: InputDecoration(
      hintText: hintText,
      hintStyle: TextStyle(fontSize: 14, color: Color(0xffCCCCCC)),
      isDense: true,
      border: InputBorder.none,
      contentPadding:
          const EdgeInsets.symmetric(horizontal: 0.0, vertical: 17.0),
    ),
    maxLines: 1,
    enableInteractiveSelection: true,
    autocorrect: false,
    autofocus: true,
    keyboardType: inputType,
    controller: editingController,
    minLines: 1,
  );
}

Widget baseRedPoint(int num) {
  return Container(
    alignment: Alignment.center,
    width: 15,
    height: 15,
    decoration: BoxDecoration(shape: BoxShape.circle, color: Color(0xffFF5963)),
    child: baseText("${num}", 11, Color(0xffFFFFFF)),
  );
}

Widget baseRefreshView(RefreshController refreshController,
    VoidCallback refresh, Widget topFix, Widget List,
    {bool pullUp = false,
    bool pullDown = true,
    VoidCallback onLoading,
    ScrollController scrollController,
    CustomScrollView customScrollView}) {
  return SmartRefresher(
      enablePullDown: pullDown,
      enablePullUp: pullUp,
      onLoading: onLoading ?? () {},
      header: normalRefreshHeader(),
      controller: refreshController,
      onRefresh: refresh,
      footer: CustomFooter(
        builder: (BuildContext context, LoadStatus mode) {
          Widget body;
//          if (mode == LoadStatus.idle) {
//            body = baseText("准备加载", 12, Color(0xff545454));
//          } else
          if (mode == LoadStatus.loading) {
            body = baseText("加载中", 12, Color(0xff545454));
          } else if (mode == LoadStatus.failed) {
            body = baseText("加载失败", 12, Color(0xff545454));
          } else if (mode == LoadStatus.noMore) {
            body = baseText("没有更多数据了", 12, Color(0xff545454));
          } else {
            body = Container();
          }
          return Container(
            height: 55.0,
            child: Center(child: body),
          );
        },
      ),
      child: customScrollView ??
          CustomScrollView(
            controller: scrollController,
            slivers: <Widget>[
              SliverToBoxAdapter(
                child: topFix,
              ),
              List,
            ],
          ));
}

Widget normalRefreshHeader() {
  return CustomHeader(
    builder: (BuildContext context, RefreshStatus mode) {
      Widget body;
//          if (mode == RefreshStatus.idle) {
//
//          } else
      if (mode == RefreshStatus.refreshing) {
        body = ImagesAnimation(
            w: 46,
            h: 15,
            durationSeconds: 1500,
            entry: ImagesAnimationEntry(1, 20, "assets/ptr_header_loading"));
      }
//            else if (mode == RefreshStatus.failed) {
//            body = Text("Load Failed!Click retry!");
//          }
      else {
        body = Image.asset(
          "assets/ptr_header_loading01.png",
          width: 46,
          height: 15,
        );
      }
      return Container(
        height: 55.0,
        child: Center(child: body),
      );
    },
  );
}
