/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanFeedBean.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';
import 'package:gm_flutter/main.mark.dart';

class PlanItem extends StatelessWidget {
  final Plans plans;
  final int pos;
  final bool isPlanPage;

  PlanItem(this.plans, this.pos, this.isPlanPage);

  @override
  Widget build(BuildContext context) {
    StringBuffer stringBuffer = StringBuffer();
    int i = 0;
    plans.baseAttrs.forEach((element) {
      stringBuffer.write(element);
      if (i != plans.baseAttrs.length - 1) {
        stringBuffer.write("|");
      }
      i++;
    });
    String rate = plans.positiveRate;
    if (rate != null && rate.contains(".")) {
      rate = rate.split(".")[0];
    }
    return Container(
      margin: EdgeInsets.only(top: 10, left: 10, right: 10),
      child: Container(
        height: 90,
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(4)),
        child: Stack(
          children: <Widget>[
            Positioned(
              top: 10,
              left: 10,
              child: Container(
                width: 70,
                height: 70,
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(4),
                  child: CachedNetworkImage(
                    imageUrl: plans.projectImage,
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            Positioned(
              left: 92,
              top: 14,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  baseText(plans.name, 14, Color(0xff282828)),
                  Container(
                    margin: EdgeInsets.only(left: 4),
                    child: Container(
                      width: 28,
                      height: 15,
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(2),
                          color: Color(0xffF0F9F7)),
                      alignment: Alignment.center,
                      child: baseText("??", 11, Color(0xff3FB5AF)),
                    ),
                  )
                ],
              ),
            ),
            Positioned(
              top: 13,
              right: 10,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.end,
                children: <Widget>[
                  baseText("好评率", 11, Color(0xff282828)),
                  Container(
                    width: 4,
                  ),
                  baseText("${rate}%", 14, Color(0xffFF5963))
                ],
              ),
            ),
            Positioned(
              bottom: 14,
              right: 10,
              child: baseText("销量${plans.salesCount}", 11, Color(0xff282828)),
            ),
            Positioned(
              left: 91,
              bottom: 14,
              child: Row(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  baseText("¥", 10, Color(0xffFF5963)),
                  baseText("${plans.minPrice}-${plans.maxPrice}", 13,
                      Color(0xffFF5963)),
                ],
              ),
            ),
            Positioned(
              left: 92,
              top: 36,
              child:
                  baseText("${stringBuffer.toString()}", 11, Color(0xff999999)),
            )
          ],
        ),
      ),
    ).gestureDetector(() {
      Map<String, dynamic> map;
      if (isPlanPage) {
        map = {
          "page_name": "plan_home",
          "tab_name": "plan_home",
          "referrer_id": "",
          "referrer": "",
          "position": pos,
          "business_id": "",
          "card_id": plans.id,
          "card_type": "card",
          "transaction_type": "",
          "card_content_type": "level_one_plan"
        };
      }

      RouterCenterImpl().findMainRouter().buriedEvent("on_click_card", map);
      RouterCenterImpl().findMainRouter().jumpPage(
          context, "level_one_plan_detail", {"planId": plans.id}, false);
    });
  }
}
