/*
 * @author lsy
 * @date   2020/7/1
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanBean.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/util/DartUtil.dart';

class SortView extends StatelessWidget {
  final List<Orders> datas;
  int selectIndex = 0;
  final Function(int index) clickIndex;

  SortView(this.datas, this.selectIndex, this.clickIndex);

  @override
  Widget build(BuildContext context) {
    if (datas == null || datas.isEmpty) {
      return Container();
    }
    return Container(
        color: Colors.white,
        child: ListView.builder(
          itemBuilder: (c, index) {
            return Container(
              margin: EdgeInsets.only(left: 15, right: 15),
              width: double.maxFinite,
              height: 45,
              child: Stack(
                children: <Widget>[
                  Positioned(
                    top: 13,
                    child: baseText(
                        datas[index].name,
                        13,
                        selectIndex == index
                            ? Color(0xff4ABAB4)
                            : Color(0xff464646)),
                  ),
                  Positioned(
                    right: 0,
                    top: 15,
                    child: selectIndex == index
                        ? Container(
                            width: 15,
                            height: 15,
                            child: Image.asset("assets/yes.png"),
                          )
                        : Container(),
                  ),
                  Positioned(
                    bottom: 0,
                    child: Container(
                      height: 0.5,
                      width: MediaQuery.of(context).size.width - 30,
                      color: Color(0xffE5E5E5),
                    ),
                  )
                ],
              ),
            ).gestureDetector(() {
              clickIndex(index);
            });
          },
          itemCount: datas.length,
        ));
  }
}
